/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.spring;

import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.config.internal.model.ApplicationModel;
import org.mule.runtime.config.internal.model.ComponentModel;
import org.springframework.AAA.beans.factory.config.RuntimeBeanReference;
import org.springframework.AAA.beans.factory.support.ManagedMap;

public class PropertyComponentUtils {
    private static final String VALUE_PARAMETER_NAME = "value";
    private static final String PROPERTY_NAME_MULE_PROPERTY_ATTRIBUTE = "key";
    private static final String PROPERTY_NAME_SPRING_PROPERTY_ATTRIBUTE = "name";
    private static final String PROPERTY_NAME_PROPERTY_ATTRIBUTE = "properties";
    private static final String REFERENCE_MULE_PROPERTY_ATTRIBUTE = "value-ref";
    private static final String REFERENCE_SPRING_PROPERTY_ATTRIBUTE = "ref";

    public static Pair<String, Object> getPropertyValueFromPropertyComponent(ComponentModel propertyComponentModel) {
        Pair<String, Object> propertyValue;
        String refKey = PropertyComponentUtils.getReferenceAttributeName(propertyComponentModel.getIdentifier());
        String nameKey = PropertyComponentUtils.getNameAttributeName(propertyComponentModel.getIdentifier());
        if (propertyComponentModel.getInnerComponents().isEmpty()) {
            Object value = propertyComponentModel.getParameters().containsKey(refKey) ? new RuntimeBeanReference(propertyComponentModel.getParameters().get(refKey)) : propertyComponentModel.getParameters().get(VALUE_PARAMETER_NAME);
            propertyValue = !propertyComponentModel.getParameters().containsKey(nameKey) ? new Pair<String, RuntimeBeanReference>(PROPERTY_NAME_PROPERTY_ATTRIBUTE, new RuntimeBeanReference(propertyComponentModel.getParameters().get(REFERENCE_SPRING_PROPERTY_ATTRIBUTE))) : new Pair<String, Object>(propertyComponentModel.getParameters().get(nameKey), value);
        } else if (propertyComponentModel.getInnerComponents().get(0).getIdentifier().getName().equals("map")) {
            ComponentModel springMap = propertyComponentModel.getInnerComponents().get(0);
            ManagedMap propertiesMap = new ManagedMap();
            springMap.getInnerComponents().stream().forEach(mapEntry -> {
                Object value = mapEntry.getParameters().containsKey(VALUE_PARAMETER_NAME) ? mapEntry.getParameters().get(VALUE_PARAMETER_NAME) : new RuntimeBeanReference(mapEntry.getParameters().get(REFERENCE_MULE_PROPERTY_ATTRIBUTE));
                propertiesMap.put(mapEntry.getParameters().get(PROPERTY_NAME_MULE_PROPERTY_ATTRIBUTE), value);
            });
            propertyValue = new Pair<String, ManagedMap<String, Object>>(propertyComponentModel.getNameAttribute(), propertiesMap);
        } else {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Unrecognized property model identifier: " + propertyComponentModel.getInnerComponents().get(0).getIdentifier()));
        }
        return propertyValue;
    }

    private static String getNameAttributeName(ComponentIdentifier identifier) {
        if (identifier.equals(ApplicationModel.MULE_PROPERTY_IDENTIFIER)) {
            return PROPERTY_NAME_MULE_PROPERTY_ATTRIBUTE;
        }
        return PROPERTY_NAME_SPRING_PROPERTY_ATTRIBUTE;
    }

    private static String getReferenceAttributeName(ComponentIdentifier identifier) {
        if (identifier.equals(ApplicationModel.MULE_PROPERTY_IDENTIFIER)) {
            return REFERENCE_MULE_PROPERTY_ATTRIBUTE;
        }
        return REFERENCE_SPRING_PROPERTY_ATTRIBUTE;
    }
}

