/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.container.internal;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.module.artifact.api.classloader.ExportedService;

public final class JreExplorer {
    private static final String META_INF_SERVICES_PATH = "META-INF/services/";

    private JreExplorer() {
    }

    public static void exploreJdk(Set<String> packages, Set<String> resources, List<ExportedService> services) {
        ArrayList<String> jdkPaths = new ArrayList<String>();
        jdkPaths.add(System.getProperty("sun.boot.class.path"));
        jdkPaths.add(System.getProperty("java.ext.dirs"));
        JreExplorer.explorePaths(jdkPaths, packages, resources, services);
    }

    static void explorePaths(List<String> jdkPaths, Set<String> packages, Set<String> resources, List<ExportedService> services) {
        Preconditions.checkArgument(jdkPaths != null && !jdkPaths.isEmpty(), "jdkPaths cannot be empty");
        for (String jdkPath : jdkPaths) {
            JreExplorer.explorePath(packages, resources, services, jdkPath);
        }
    }

    private static void explorePath(Set<String> packages, Set<String> resources, List<ExportedService> services, String jdkPath) {
        int endIndex;
        int fromIndex = 0;
        do {
            String item;
            File file;
            if ((file = new File(item = (endIndex = jdkPath.indexOf(File.pathSeparatorChar, fromIndex)) == -1 ? jdkPath.substring(fromIndex) : jdkPath.substring(fromIndex, endIndex))).exists()) {
                if (file.isDirectory()) {
                    JreExplorer.exploreDirectory(packages, resources, services, file);
                } else {
                    try {
                        JreExplorer.exploreJar(packages, resources, services, file);
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(JreExplorer.createJarExploringError(file), e);
                    }
                }
            }
            fromIndex = endIndex + 1;
        } while (endIndex != -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void exploreJar(Set<String> packages, Set<String> resources, List<ExportedService> services, File file) throws IOException {
        ZipFile zipFile = new ZipFile(file);
        try {
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                int lastSlash = name.lastIndexOf(47);
                if (lastSlash != -1 && name.endsWith(".class")) {
                    packages.add(name.substring(0, lastSlash).replaceAll("/", "."));
                    continue;
                }
                if (entry.isDirectory()) continue;
                if (name.startsWith(META_INF_SERVICES_PATH)) {
                    String serviceInterface = name.substring(META_INF_SERVICES_PATH.length());
                    URL resource = JreExplorer.getServiceResourceUrl(file.toURI().toURL(), name);
                    services.add(new ExportedService(serviceInterface, resource));
                    continue;
                }
                resources.add(name);
            }
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private static void exploreDirectory(Set<String> packages, Set<String> resources, List<ExportedService> services, File file) {
        for (File entry : file.listFiles()) {
            if (entry.isDirectory()) {
                JreExplorer.exploreDirectory(packages, resources, services, entry);
                continue;
            }
            if (!entry.getName().endsWith(".jar")) continue;
            try {
                JreExplorer.exploreJar(packages, resources, services, entry);
            }
            catch (IOException e) {
                throw new IllegalStateException(JreExplorer.createJarExploringError(entry), e);
            }
        }
    }

    private static String createJarExploringError(File file) {
        return String.format("Unable to explore '%s'", file.getAbsoluteFile());
    }

    static URL getServiceResourceUrl(URL resource, String serviceInterface) throws MalformedURLException {
        return new URL("jar:" + resource + "!/" + serviceInterface);
    }
}

