/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.config.bootstrap;

import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.config.bootstrap.BootstrapService;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.core.internal.config.bootstrap.AbstractBootstrapProperty;

public class TransactionFactoryBootstrapProperty
extends AbstractBootstrapProperty {
    private final String transactionFactoryClassName;
    private final String transactionResourceClassName;

    public TransactionFactoryBootstrapProperty(BootstrapService service, ArtifactType artifactType, Boolean optional, String transactionFactoryClassName, String transactionResourceClassName) {
        super(service, artifactType, optional);
        Preconditions.checkArgument(!StringUtils.isEmpty(transactionFactoryClassName), "key cannot be empty");
        Preconditions.checkArgument(!StringUtils.isEmpty(transactionResourceClassName), "className cannot be empty");
        this.transactionFactoryClassName = transactionFactoryClassName;
        this.transactionResourceClassName = transactionResourceClassName;
    }

    public String getTransactionFactoryClassName() {
        return this.transactionFactoryClassName;
    }

    public String getTransactionResourceClassName() {
        return this.transactionResourceClassName;
    }

    public String toString() {
        return String.format("TransactionFactory{ %s}", this.transactionResourceClassName);
    }
}

