/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.api.domain.message.response;

import java.util.Collection;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.BaseHttpMessage;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.ResponseStatus;

class DefaultHttpResponse
extends BaseHttpMessage
implements HttpResponse {
    private final HttpEntity body;
    private ResponseStatus responseStatus = new ResponseStatus();
    private MultiMap<String, String> headers = new MultiMap();

    DefaultHttpResponse(ResponseStatus responseStatus, MultiMap<String, String> headers, HttpEntity body) {
        this.responseStatus = responseStatus;
        this.headers = headers;
        this.body = body;
    }

    @Override
    public HttpEntity getEntity() {
        return this.body;
    }

    @Override
    public Collection<String> getHeaderNames() {
        return this.headers.keySet();
    }

    @Override
    public String getHeaderValue(String headerName) {
        return this.headers.get(headerName);
    }

    @Override
    public Collection<String> getHeaderValues(String headerName) {
        return this.headers.getAll(headerName);
    }

    @Override
    public int getStatusCode() {
        return this.responseStatus.getStatusCode();
    }

    @Override
    public String getReasonPhrase() {
        return this.responseStatus.getReasonPhrase();
    }

    public String toString() {
        return "DefaultHttpResponse {" + System.lineSeparator() + "  responseStatus: " + this.responseStatus.getStatusCode() + " (" + this.responseStatus.getReasonPhrase() + ")," + System.lineSeparator() + "  headers: " + this.headers.toString() + System.lineSeparator() + "}";
    }
}

