/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.capability.xml.schema;

import com.google.common.collect.ImmutableMap;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.api.util.collection.Collectors;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.module.extension.internal.capability.xml.schema.MethodDocumentation;
import org.mule.runtime.module.extension.internal.capability.xml.schema.doc.JavaDocModel;
import org.mule.runtime.module.extension.internal.capability.xml.schema.doc.JavaDocReader;

public final class ExtensionAnnotationProcessor {
    private static final String VALUE = "value";

    public <T> Optional<Class<T>> classFor(TypeElement typeElement, ProcessingEnvironment processingEnvironment) {
        try {
            return Optional.of(ClassUtils.loadClass(this.getClassName(typeElement, processingEnvironment), typeElement.getClass()));
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }

    public String getClassName(TypeElement typeElement, ProcessingEnvironment processingEnvironment) {
        return processingEnvironment.getElementUtils().getBinaryName(typeElement).toString();
    }

    public Set<TypeElement> getTypeElementsAnnotatedWith(Class<? extends Annotation> annotationType, RoundEnvironment roundEnvironment) {
        return ElementFilter.typesIn(roundEnvironment.getElementsAnnotatedWith(annotationType));
    }

    public List<TypeElement> getAnnotationClassesValue(Element element, Class<? extends Annotation> annotation, Class[] valueClasses) {
        List annotationValues = (List)this.getAnnotationValue(element, annotation);
        if (annotation == null) {
            return Collections.emptyList();
        }
        return Stream.of(valueClasses).map(c -> (TypeElement)this.getElementForClass(annotationValues, (Class<?>)c)).collect(Collectors.toImmutableList());
    }

    public <T> T getAnnotationFromType(ProcessingEnvironment processingEnvironment, TypeElement rootElement, Class<? extends Annotation> annotationClass) {
        return (T)this.classFor(rootElement, processingEnvironment).get().getAnnotation(annotationClass);
    }

    public Element getElementForClass(List<AnnotationValue> annotationValues, Class<?> clazz) {
        return annotationValues.stream().map(e -> ((DeclaredType)e.getValue()).asElement()).filter(e -> e.getSimpleName().toString().equals(clazz.getSimpleName())).findFirst().orElse(null);
    }

    public Map<String, VariableElement> getFieldsAnnotatedWith(TypeElement element, Class<? extends Annotation> annotation) {
        if (element == null) {
            return Collections.emptyMap();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        TypeElement superClass = this.getSuperclassElement(element);
        builder.putAll(this.getFieldsAnnotatedWith(superClass, annotation));
        builder.putAll(this.collectAnnotatedElements(ElementFilter.fieldsIn(element.getEnclosedElements()), annotation));
        return builder.build();
    }

    private TypeElement getSuperclassElement(Element element) {
        TypeMirror superclass;
        if (element instanceof TypeElement && (superclass = ((TypeElement)element).getSuperclass()) instanceof DeclaredType) {
            return (TypeElement)((DeclaredType)superclass).asElement();
        }
        return null;
    }

    private <T extends Element> Map<String, T> collectAnnotatedElements(Iterable<T> elements, Class<? extends Annotation> clazz) {
        ImmutableMap.Builder fields = ImmutableMap.builder();
        elements.forEach(e -> {
            if (e.getAnnotation(clazz) != null) {
                fields.put((Object)e.getSimpleName().toString(), e);
            }
        });
        return fields.build();
    }

    public MethodDocumentation getMethodDocumentation(ProcessingEnvironment processingEnv, Element element) {
        JavaDocModel javadocModel = JavaDocReader.parseJavaDoc(processingEnv, element);
        this.parseOperationParameterGroups(processingEnv, (ExecutableElement)element, javadocModel.getParameters());
        return new MethodDocumentation(javadocModel.getBody(), javadocModel.getParameters());
    }

    private void parseOperationParameterGroups(ProcessingEnvironment env, ExecutableElement method, Map<String, String> docs) {
        for (VariableElement variableElement : method.getParameters()) {
            for (AnnotationMirror annotationMirror : variableElement.getAnnotationMirrors()) {
                Class annotationClass;
                DeclaredType annotationType = annotationMirror.getAnnotationType();
                if (annotationType == null || !ParameterGroup.class.isAssignableFrom(annotationClass = this.classFor((TypeElement)annotationMirror.getAnnotationType().asElement(), env).get())) continue;
                try {
                    this.getOperationParameterGroupDocumentation((TypeElement)env.getTypeUtils().asElement(variableElement.asType()), docs, env);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private void getOperationParameterGroupDocumentation(TypeElement groupElement, Map<String, String> parameterDocs, ProcessingEnvironment processingEnvironment) {
        this.getFieldsAnnotatedWith(groupElement, Parameter.class).forEach((key, value) -> parameterDocs.put((String)key, this.getJavaDocSummary(processingEnvironment, (Element)value)));
        this.getFieldsAnnotatedWith(groupElement, ParameterGroup.class).values().forEach(field -> this.getOperationParameterGroupDocumentation((TypeElement)processingEnvironment.getTypeUtils().asElement(field.asType()), parameterDocs, processingEnvironment));
    }

    public String getJavaDocSummary(ProcessingEnvironment processingEnv, Element element) {
        return JavaDocReader.parseJavaDoc(processingEnv, element).getBody();
    }

    public <T> T getAnnotationValue(Element rootElement, Class<? extends Annotation> anAnnotation) {
        if (rootElement.getAnnotation(anAnnotation) != null) {
            String fullQualifiedAnnotationName = anAnnotation.getName();
            Reference annotationFieldValue = new Reference();
            rootElement.getAnnotationMirrors().stream().filter(annotationMirror -> fullQualifiedAnnotationName.equals(annotationMirror.getAnnotationType().toString())).forEach(annotationMirror -> annotationMirror.getElementValues().entrySet().stream().filter(entry -> VALUE.equals(((ExecutableElement)entry.getKey()).getSimpleName().toString())).findFirst().ifPresent(entry -> annotationFieldValue.set(((AnnotationValue)entry.getValue()).getValue())));
            return annotationFieldValue.get();
        }
        return null;
    }
}

