/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.visitor.BasicTypeMetadataVisitor;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.declaration.fluent.BaseDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.Declarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasNestedComponentsDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasParametersDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.NamedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclarer;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.ConfigOverride;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.ExclusiveOptionals;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalParameterModelDefinitionException;
import org.mule.runtime.extension.api.property.DefaultImplementingTypeModelProperty;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.module.extension.internal.loader.ParameterGroupDescriptor;
import org.mule.runtime.module.extension.internal.loader.java.MuleExtensionAnnotationParser;
import org.mule.runtime.module.extension.internal.loader.java.contributor.ParameterDeclarerContributor;
import org.mule.runtime.module.extension.internal.loader.java.property.DeclaringMemberModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingParameterModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.NullSafeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ParameterGroupModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.internal.loader.java.type.FieldElement;
import org.mule.runtime.module.extension.internal.loader.java.type.Type;
import org.mule.runtime.module.extension.internal.loader.java.type.WithAlias;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.FieldWrapper;
import org.mule.runtime.module.extension.internal.loader.utils.ModelLoaderUtils;
import org.mule.runtime.module.extension.internal.loader.utils.ParameterDeclarationContext;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public final class ParameterModelsLoaderDelegate {
    private List<ParameterDeclarerContributor> contributors;
    private ClassTypeLoader typeLoader;

    public ParameterModelsLoaderDelegate(List<ParameterDeclarerContributor> contributors, ClassTypeLoader loader) {
        this.contributors = contributors;
        this.typeLoader = loader;
    }

    public List<ParameterDeclarer> declare(HasParametersDeclarer component, List<? extends ExtensionParameter> parameters, ParameterDeclarationContext declarationContext) {
        return this.declare(component, parameters, declarationContext, null);
    }

    public List<ParameterDeclarer> declare(HasParametersDeclarer component, List<? extends ExtensionParameter> parameters, ParameterDeclarationContext declarationContext, ParameterGroupDeclarer parameterGroupDeclarer) {
        ArrayList<ParameterDeclarer> declarerList = new ArrayList<ParameterDeclarer>();
        this.checkAnnotationsNotUsedMoreThanOnce(parameters, Connection.class, Config.class, MetadataKeyId.class);
        boolean supportsNestedElements = component instanceof HasNestedComponentsDeclarer;
        for (ExtensionParameter extensionParameter : parameters) {
            ParameterGroupDeclarer groupDeclarer;
            if (supportsNestedElements && this.declaredAsNestedComponent((HasNestedComponentsDeclarer)((Object)component), extensionParameter) || !extensionParameter.shouldBeAdvertised() || this.declaredAsGroup(component, declarationContext, extensionParameter)) continue;
            ParameterGroupDeclarer parameterGroupDeclarer2 = groupDeclarer = parameterGroupDeclarer != null ? parameterGroupDeclarer : component.onDefaultParameterGroup();
            ParameterDeclarer parameter = extensionParameter.isRequired() ? groupDeclarer.withRequiredParameter(extensionParameter.getAlias()) : groupDeclarer.withOptionalParameter(extensionParameter.getAlias()).defaultingTo(extensionParameter.defaultValue().isPresent() ? extensionParameter.defaultValue().get() : null);
            ((ParameterDeclarer)parameter.ofType(extensionParameter.getMetadataType(this.typeLoader))).describedAs(extensionParameter.getDescription());
            this.parseParameterRole(extensionParameter, parameter);
            this.parseExpressionSupport(extensionParameter, parameter);
            this.parseConfigOverride(extensionParameter, parameter);
            this.parseNullSafe(extensionParameter, parameter);
            this.parseLayout(extensionParameter, parameter);
            this.addImplementingTypeModelProperty(extensionParameter, parameter);
            this.parseParameterDsl(extensionParameter, parameter);
            this.contributors.forEach(contributor -> contributor.contribute(extensionParameter, parameter, declarationContext));
            declarerList.add(parameter);
        }
        return declarerList;
    }

    private boolean declaredAsNestedComponent(HasNestedComponentsDeclarer component, ExtensionParameter extensionParameter) {
        if (ModelLoaderUtils.isProcessorChain(extensionParameter)) {
            component.withChain(extensionParameter.getAlias()).setRequired(extensionParameter.isRequired()).describedAs(extensionParameter.getDescription());
            return true;
        }
        return false;
    }

    private void parseConfigOverride(ExtensionParameter extensionParameter, ParameterDeclarer parameter) {
        if (extensionParameter.getAnnotation(ConfigOverride.class).isPresent()) {
            parameter.asConfigOverride();
        }
    }

    private boolean declaredAsGroup(HasParametersDeclarer component, ParameterDeclarationContext declarationContext, ExtensionParameter groupParameter) throws IllegalParameterModelDefinitionException {
        ParameterGroup groupAnnotation = groupParameter.getAnnotation(ParameterGroup.class).orElse(null);
        if (groupAnnotation == null) {
            return false;
        }
        String groupName = groupAnnotation.name();
        if ("General".equals(groupName)) {
            throw new IllegalParameterModelDefinitionException(String.format("%s '%s' defines parameter group of name '%s' which is the default one. @%s cannot be used with the default group name", NameUtils.getComponentDeclarationTypeName(((Declarer)((Object)component)).getDeclaration()), ((NamedDeclaration)((Declarer)((Object)component)).getDeclaration()).getName(), groupName, ParameterGroup.class.getSimpleName()));
        }
        Type type = groupParameter.getType();
        List<FieldElement> nestedGroups = type.getAnnotatedFields(ParameterGroup.class);
        if (!nestedGroups.isEmpty()) {
            throw new IllegalParameterModelDefinitionException(String.format("Class '%s' is used as a @%s but contains fields which also hold that annotation. Nesting groups is not allowed. Offending fields are: [%s]", type.getName(), ParameterGroup.class.getSimpleName(), nestedGroups.stream().map(element -> element.getName()).collect(Collectors.joining(","))));
        }
        if (groupParameter.isAnnotatedWith(Optional.class)) {
            throw new IllegalParameterModelDefinitionException(String.format("@%s can not be applied alongside with @%s. Affected parameter is [%s].", Optional.class.getSimpleName(), ParameterGroup.class.getSimpleName(), groupParameter.getName()));
        }
        ParameterGroupDeclarer declarer = component.onParameterGroup(groupName);
        if (((BaseDeclaration)declarer.getDeclaration()).getModelProperty(ParameterGroupModelProperty.class).isPresent()) {
            throw new IllegalParameterModelDefinitionException(String.format("Parameter group '%s' has already been declared on %s '%s'", groupName, NameUtils.getComponentDeclarationTypeName(((Declarer)((Object)component)).getDeclaration()), ((NamedDeclaration)((Declarer)((Object)component)).getDeclaration()).getName()));
        }
        declarer.withModelProperty(new ParameterGroupModelProperty(new ParameterGroupDescriptor(groupName, type, groupParameter.getMetadataType(this.typeLoader), groupParameter.getDeclaringElement())));
        List<FieldElement> annotatedParameters = type.getAnnotatedFields(org.mule.runtime.extension.api.annotation.param.Parameter.class);
        type.getAnnotation(ExclusiveOptionals.class).ifPresent(annotation -> {
            Set<String> optionalParamNames = annotatedParameters.stream().filter(f -> !f.isRequired()).map(WithAlias::getAlias).collect(Collectors.toSet());
            declarer.withExclusiveOptionals(optionalParamNames, annotation.isOneRequired());
        });
        declarer.withDslInlineRepresentation(groupAnnotation.showInDsl());
        MuleExtensionAnnotationParser.parseLayoutAnnotations(groupParameter, LayoutModel.builder()).ifPresent(declarer::withLayout);
        if (!annotatedParameters.isEmpty()) {
            this.declare(component, annotatedParameters, declarationContext, declarer);
        } else {
            Class declaringClass = type.getDeclaringClass();
            List fields = IntrospectionUtils.getFieldsWithGetters(declaringClass).stream().map(FieldWrapper::new).collect(Collectors.toList());
            this.declare(component, fields, declarationContext, declarer);
        }
        return true;
    }

    private void parseParameterRole(ExtensionParameter extensionParameter, ParameterDeclarer parameter) {
        parameter.withRole(ExtensionModelUtils.roleOf(extensionParameter.getAnnotation(Content.class)));
    }

    private void parseExpressionSupport(ExtensionParameter extensionParameter, ParameterDeclarer parameter) {
        extensionParameter.getAnnotation(Expression.class).ifPresent(expression -> parameter.withExpressionSupport(IntrospectionUtils.getExpressionSupport(expression)));
    }

    private void parseNullSafe(final ExtensionParameter extensionParameter, final ParameterDeclarer parameter) {
        if (extensionParameter.isAnnotatedWith(NullSafe.class)) {
            if (extensionParameter.isAnnotatedWith(ConfigOverride.class)) {
                throw new IllegalParameterModelDefinitionException(String.format("Parameter '%s' is annotated with '@%s' and also marked as a config override, which is redundant. The default value for this parameter will come from the configuration parameter", extensionParameter.getName(), NullSafe.class.getSimpleName()));
            }
            if (extensionParameter.isRequired() && !extensionParameter.isAnnotatedWith(ParameterGroup.class)) {
                throw new IllegalParameterModelDefinitionException(String.format("Parameter '%s' is required but annotated with '@%s', which is redundant", extensionParameter.getName(), NullSafe.class.getSimpleName()));
            }
            Class<?> defaultType = extensionParameter.getAnnotation(NullSafe.class).get().defaultImplementingType();
            final boolean hasDefaultOverride = !defaultType.equals(Object.class);
            final MetadataType nullSafeType = hasDefaultOverride ? this.typeLoader.load(defaultType) : parameter.getDeclaration().getType();
            parameter.getDeclaration().getType().accept(new BasicTypeMetadataVisitor(){

                @Override
                protected void visitBasicType(MetadataType metadataType) {
                    throw new IllegalParameterModelDefinitionException(String.format("Parameter '%s' is annotated with '@%s' but is of type '%s'. That annotation can only be used with complex types (Pojos, Lists, Maps)", extensionParameter.getName(), NullSafe.class.getSimpleName(), extensionParameter.getType().getName()));
                }

                @Override
                public void visitArrayType(ArrayType arrayType) {
                    if (hasDefaultOverride) {
                        throw new IllegalParameterModelDefinitionException(String.format("Parameter '%s' is annotated with '@%s' is of type '%s' but a 'defaultImplementingType' was provided. Type override is not allowed for Collections", extensionParameter.getName(), NullSafe.class.getSimpleName(), extensionParameter.getType().getName()));
                    }
                }

                @Override
                public void visitObject(ObjectType objectType) {
                    if (hasDefaultOverride && ExtensionMetadataTypeUtils.isMap(objectType)) {
                        throw new IllegalParameterModelDefinitionException(String.format("Parameter '%s' is annotated with '@%s' is of type '%s' but a 'defaultImplementingType' was provided. Type override is not allowed for Maps", extensionParameter.getName(), NullSafe.class.getSimpleName(), extensionParameter.getType().getName()));
                    }
                    if (hasDefaultOverride && IntrospectionUtils.isInstantiable(objectType)) {
                        throw new IllegalParameterModelDefinitionException(String.format("Parameter '%s' is annotated with '@%s' is of concrete type '%s', but a 'defaultImplementingType' was provided. Type override is not allowed for concrete types", extensionParameter.getName(), NullSafe.class.getSimpleName(), extensionParameter.getType().getName()));
                    }
                    if (!IntrospectionUtils.isInstantiable(nullSafeType) && !ExtensionMetadataTypeUtils.isMap(nullSafeType)) {
                        throw new IllegalParameterModelDefinitionException(String.format("Parameter '%s' is annotated with '@%s' but is of type '%s'. That annotation can only be used with complex instantiable types (Pojos, Lists, Maps)", extensionParameter.getName(), NullSafe.class.getSimpleName(), extensionParameter.getType().getName()));
                    }
                    if (hasDefaultOverride && !JavaTypeUtils.getType(parameter.getDeclaration().getType()).isAssignableFrom(JavaTypeUtils.getType(nullSafeType))) {
                        throw new IllegalParameterModelDefinitionException(String.format("Parameter '%s' is annotated with '@%s' of type '%s', but provided type '%s is not a subtype of the parameter's type", extensionParameter.getName(), NullSafe.class.getSimpleName(), extensionParameter.getType().getName(), JavaTypeUtils.getType(nullSafeType).getName()));
                    }
                }
            });
            parameter.withModelProperty(new NullSafeModelProperty(nullSafeType));
            if (hasDefaultOverride) {
                parameter.withModelProperty(new DefaultImplementingTypeModelProperty(nullSafeType));
            }
        }
    }

    private void parseLayout(ExtensionParameter extensionParameter, ParameterDeclarer parameter) {
        MuleExtensionAnnotationParser.parseLayoutAnnotations(extensionParameter, LayoutModel.builder()).ifPresent(parameter::withLayout);
    }

    private void parseParameterDsl(ExtensionParameter extensionParameter, ParameterDeclarer parameter) {
        extensionParameter.getAnnotation(ParameterDsl.class).ifPresent(parameterDsl -> parameter.withDsl(ParameterDslConfiguration.builder().allowsInlineDefinition(parameterDsl.allowInlineDefinition()).allowsReferences(parameterDsl.allowReferences()).build()));
    }

    private void checkAnnotationsNotUsedMoreThanOnce(List<? extends ExtensionParameter> parameters, Class<? extends Annotation> ... annotations) {
        for (Class<? extends Annotation> annotation : annotations) {
            long count = parameters.stream().filter(param -> param.isAnnotatedWith(annotation)).count();
            if (count <= 1L) continue;
            throw new IllegalModelDefinitionException(String.format("The defined parameters %s from %s, uses the annotation @%s more than once", parameters.stream().map(p -> p.getName()).collect(Collectors.toList()), parameters.iterator().next().getOwnerDescription(), annotation.getSimpleName()));
        }
    }

    private void addImplementingTypeModelProperty(ExtensionParameter extensionParameter, ParameterDeclarer parameter) {
        AnnotatedElement element = extensionParameter.getDeclaringElement();
        parameter.withModelProperty(element instanceof Field ? new DeclaringMemberModelProperty((Field)element) : new ImplementingParameterModelProperty((Parameter)element));
    }
}

