/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.value;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ValueProviderModel;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.extension.api.values.ValueBuilder;

public class ValueProviderUtils {
    static ValueBuilder cloneAndEnrichValue(Value value, Map<Integer, String> partOrderMapping) {
        return ValueProviderUtils.cloneAndEnrichValue(value, partOrderMapping, 1);
    }

    static ValueBuilder cloneAndEnrichValue(Value value, List<ParameterModel> parameters) {
        return ValueProviderUtils.cloneAndEnrichValue(value, ValueProviderUtils.orderParts(parameters), 1);
    }

    static ValueBuilder cloneAndEnrichValue(Value value, Map<Integer, String> partOrderMapping, int level) {
        ValueBuilder keyBuilder = ValueBuilder.newValue(value.getId(), partOrderMapping.get(level)).withDisplayName(value.getDisplayName());
        value.getChilds().forEach(childKey -> keyBuilder.withChild(ValueProviderUtils.cloneAndEnrichValue(childKey, partOrderMapping, level + 1)));
        return keyBuilder;
    }

    private static Map<Integer, String> orderParts(List<ParameterModel> parameters) {
        return parameters.stream().collect(Collectors.toMap(param -> param.getValueProviderModel().get().getPartOrder(), NamedObject::getName));
    }

    public static List<ValueProviderModel> getValueProviderModels(List<ParameterModel> parameterModels) {
        return parameterModels.stream().map(parameterModel -> parameterModel.getValueProviderModel().orElse(null)).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

