/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.reboot.internal;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.mule.runtime.module.reboot.MuleContainerBootstrap;
import org.mule.runtime.module.reboot.internal.DefaultMuleClassPathConfig;
import org.mule.runtime.module.reboot.internal.MuleContainerSystemClassLoader;
import org.tanukisoftware.wrapper.WrapperListener;
import org.tanukisoftware.wrapper.WrapperManager;

public class MuleContainerWrapper
implements WrapperListener {
    protected static final String CLASSNAME_MULE_CONTAINER = "org.mule.runtime.module.launcher.MuleContainer";
    private Object mule;

    @Override
    public Integer start(String[] args) {
        try {
            ClassLoader muleSystemCl = this.createContainerSystemClassLoader();
            Thread.currentThread().setContextClassLoader(muleSystemCl);
            Class<?> muleClass = Thread.currentThread().getContextClassLoader().loadClass(CLASSNAME_MULE_CONTAINER);
            Constructor<?> c = muleClass.getConstructor(String[].class);
            this.mule = c.newInstance(new Object[]{args});
            Method startMethod = muleClass.getMethod("start", Boolean.TYPE);
            startMethod.invoke(this.mule, true);
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
    }

    protected ClassLoader createContainerSystemClassLoader() throws Exception {
        File muleHome = MuleContainerBootstrap.lookupMuleHome();
        File muleBase = MuleContainerBootstrap.lookupMuleBase();
        DefaultMuleClassPathConfig config = new DefaultMuleClassPathConfig(muleHome, muleBase);
        return new MuleContainerSystemClassLoader(config);
    }

    @Override
    public int stop(int exitCode) {
        try {
            Method shutdownMethod = this.mule.getClass().getMethod("shutdown", new Class[0]);
            shutdownMethod.invoke(this.mule, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return exitCode;
    }

    @Override
    public void controlEvent(int event) {
        if (!(WrapperManager.isControlledByNativeWrapper() || event != 200 && event != 201 && event != 203)) {
            WrapperManager.stop(0);
        }
    }
}

