/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.AAA.aop.config;

import org.springframework.AAA.aop.aspectj.AspectInstanceFactory;
import org.springframework.AAA.beans.factory.BeanFactory;
import org.springframework.AAA.beans.factory.BeanFactoryAware;
import org.springframework.AAA.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.AAA.core.Ordered;
import org.springframework.AAA.util.ClassUtils;
import org.springframework.AAA.util.StringUtils;

public class SimpleBeanFactoryAwareAspectInstanceFactory
implements AspectInstanceFactory,
BeanFactoryAware {
    private String aspectBeanName;
    private BeanFactory beanFactory;

    public void setAspectBeanName(String aspectBeanName) {
        this.aspectBeanName = aspectBeanName;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        if (!StringUtils.hasText(this.aspectBeanName)) {
            throw new IllegalArgumentException("'aspectBeanName' is required");
        }
    }

    @Override
    public Object getAspectInstance() {
        return this.beanFactory.getBean(this.aspectBeanName);
    }

    @Override
    public ClassLoader getAspectClassLoader() {
        if (this.beanFactory instanceof ConfigurableBeanFactory) {
            return ((ConfigurableBeanFactory)this.beanFactory).getBeanClassLoader();
        }
        return ClassUtils.getDefaultClassLoader();
    }

    @Override
    public int getOrder() {
        if (this.beanFactory.isSingleton(this.aspectBeanName) && this.beanFactory.isTypeMatch(this.aspectBeanName, Ordered.class)) {
            return ((Ordered)this.beanFactory.getBean(this.aspectBeanName)).getOrder();
        }
        return Integer.MAX_VALUE;
    }
}

