/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.AAA.aop.framework;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.AAA.aop.framework.AdvisedSupport;
import org.springframework.AAA.aop.framework.AopConfigException;
import org.springframework.AAA.aop.framework.CglibAopProxy;
import org.springframework.AAA.cglib.proxy.Callback;
import org.springframework.AAA.cglib.proxy.Enhancer;
import org.springframework.AAA.cglib.proxy.Factory;
import org.springframework.AAA.objenesis.ObjenesisStd;

class ObjenesisCglibAopProxy
extends CglibAopProxy {
    private static final Log logger = LogFactory.getLog(ObjenesisCglibAopProxy.class);
    private final ObjenesisStd objenesis = new ObjenesisStd(true);

    public ObjenesisCglibAopProxy(AdvisedSupport config) {
        super(config);
    }

    @Override
    protected Object createProxyClassAndInstance(Enhancer enhancer, Callback[] callbacks) {
        Class proxyClass = enhancer.createClass();
        Object proxyInstance = null;
        try {
            proxyInstance = this.objenesis.newInstance(proxyClass);
        }
        catch (Throwable ex) {
            logger.debug("Unable to instantiate proxy using Objenesis, falling back to regular proxy construction", ex);
        }
        if (proxyInstance == null) {
            try {
                proxyInstance = (this.constructorArgs != null ? proxyClass.getConstructor(this.constructorArgTypes).newInstance(this.constructorArgs) : proxyClass.newInstance());
            }
            catch (Throwable ex) {
                throw new AopConfigException("Unable to instantiate proxy using Objenesis, and regular proxy instantiation via default constructor fails as well", ex);
            }
        }
        ((Factory)proxyInstance).setCallbacks(callbacks);
        return proxyInstance;
    }
}

