/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.AAA.aop.interceptor;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.AAA.aop.interceptor.AsyncUncaughtExceptionHandler;
import org.springframework.AAA.aop.interceptor.SimpleAsyncUncaughtExceptionHandler;
import org.springframework.AAA.beans.factory.BeanFactory;
import org.springframework.AAA.beans.factory.BeanFactoryAware;
import org.springframework.AAA.beans.factory.annotation.BeanFactoryAnnotationUtils;
import org.springframework.AAA.core.task.AsyncListenableTaskExecutor;
import org.springframework.AAA.core.task.AsyncTaskExecutor;
import org.springframework.AAA.core.task.support.TaskExecutorAdapter;
import org.springframework.AAA.util.ReflectionUtils;
import org.springframework.AAA.util.StringUtils;

public abstract class AsyncExecutionAspectSupport
implements BeanFactoryAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Map<Method, AsyncTaskExecutor> executors = new ConcurrentHashMap<Method, AsyncTaskExecutor>(16);
    private Executor defaultExecutor;
    private AsyncUncaughtExceptionHandler exceptionHandler;
    private BeanFactory beanFactory;

    public AsyncExecutionAspectSupport(Executor defaultExecutor, AsyncUncaughtExceptionHandler exceptionHandler) {
        this.defaultExecutor = defaultExecutor;
        this.exceptionHandler = exceptionHandler;
    }

    public AsyncExecutionAspectSupport(Executor defaultExecutor) {
        this(defaultExecutor, new SimpleAsyncUncaughtExceptionHandler());
    }

    public void setExecutor(Executor defaultExecutor) {
        this.defaultExecutor = defaultExecutor;
    }

    public void setExceptionHandler(AsyncUncaughtExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    protected AsyncTaskExecutor determineAsyncExecutor(Method method) {
        AsyncTaskExecutor executor = this.executors.get(method);
        if (executor == null) {
            Executor executorToUse = this.defaultExecutor;
            String qualifier = this.getExecutorQualifier(method);
            if (StringUtils.hasLength(qualifier)) {
                if (this.beanFactory == null) {
                    throw new IllegalStateException("BeanFactory must be set on " + this.getClass().getSimpleName() + " to access qualified executor '" + qualifier + "'");
                }
                executorToUse = BeanFactoryAnnotationUtils.qualifiedBeanOfType(this.beanFactory, Executor.class, qualifier);
            } else if (executorToUse == null) {
                return null;
            }
            executor = executorToUse instanceof AsyncListenableTaskExecutor ? (AsyncListenableTaskExecutor)executorToUse : new TaskExecutorAdapter(executorToUse);
            this.executors.put(method, executor);
        }
        return executor;
    }

    protected abstract String getExecutorQualifier(Method var1);

    protected void handleError(Throwable ex, Method method, Object ... params) throws Exception {
        if (Future.class.isAssignableFrom(method.getReturnType())) {
            ReflectionUtils.rethrowException(ex);
        } else {
            try {
                this.exceptionHandler.handleUncaughtException(ex, method, params);
            }
            catch (Throwable ex2) {
                this.logger.error("Exception handler for async method '" + method.toGenericString() + "' threw unexpected exception itself", ex2);
            }
        }
    }
}

