/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.AAA.beans;

import java.lang.reflect.Field;
import org.springframework.AAA.beans.ConversionNotSupportedException;
import org.springframework.AAA.beans.PropertyEditorRegistrySupport;
import org.springframework.AAA.beans.TypeConverter;
import org.springframework.AAA.beans.TypeConverterDelegate;
import org.springframework.AAA.beans.TypeMismatchException;
import org.springframework.AAA.core.MethodParameter;
import org.springframework.AAA.core.convert.ConversionException;
import org.springframework.AAA.core.convert.ConverterNotFoundException;

public abstract class TypeConverterSupport
extends PropertyEditorRegistrySupport
implements TypeConverter {
    TypeConverterDelegate typeConverterDelegate;

    @Override
    public <T> T convertIfNecessary(Object value, Class<T> requiredType) throws TypeMismatchException {
        return this.doConvert(value, requiredType, null, null);
    }

    @Override
    public <T> T convertIfNecessary(Object value, Class<T> requiredType, MethodParameter methodParam) throws TypeMismatchException {
        return this.doConvert(value, requiredType, methodParam, null);
    }

    @Override
    public <T> T convertIfNecessary(Object value, Class<T> requiredType, Field field) throws TypeMismatchException {
        return this.doConvert(value, requiredType, null, field);
    }

    private <T> T doConvert(Object value, Class<T> requiredType, MethodParameter methodParam, Field field) throws TypeMismatchException {
        try {
            if (field != null) {
                return this.typeConverterDelegate.convertIfNecessary(value, requiredType, field);
            }
            return this.typeConverterDelegate.convertIfNecessary(value, requiredType, methodParam);
        }
        catch (ConverterNotFoundException ex) {
            throw new ConversionNotSupportedException(value, requiredType, (Throwable)ex);
        }
        catch (ConversionException ex) {
            throw new TypeMismatchException(value, requiredType, (Throwable)ex);
        }
        catch (IllegalStateException ex) {
            throw new ConversionNotSupportedException(value, requiredType, (Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            throw new TypeMismatchException(value, requiredType, (Throwable)ex);
        }
    }
}

