/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.AAA.beans.factory.config;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.AAA.beans.BeanUtils;
import org.springframework.AAA.beans.TypeConverter;
import org.springframework.AAA.beans.factory.config.AbstractFactoryBean;
import org.springframework.AAA.core.GenericCollectionTypeResolver;

public class MapFactoryBean
extends AbstractFactoryBean<Map<Object, Object>> {
    private Map<?, ?> sourceMap;
    private Class<? extends Map> targetMapClass;

    public void setSourceMap(Map<?, ?> sourceMap) {
        this.sourceMap = sourceMap;
    }

    public void setTargetMapClass(Class<? extends Map> targetMapClass) {
        if (targetMapClass == null) {
            throw new IllegalArgumentException("'targetMapClass' must not be null");
        }
        if (!Map.class.isAssignableFrom(targetMapClass)) {
            throw new IllegalArgumentException("'targetMapClass' must implement [java.util.Map]");
        }
        this.targetMapClass = targetMapClass;
    }

    @Override
    public Class<Map> getObjectType() {
        return Map.class;
    }

    @Override
    protected Map<Object, Object> createInstance() {
        if (this.sourceMap == null) {
            throw new IllegalArgumentException("'sourceMap' is required");
        }
        LinkedHashMap<Object, Object> result = null;
        result = this.targetMapClass != null ? BeanUtils.instantiateClass(this.targetMapClass) : new LinkedHashMap<Object, Object>(this.sourceMap.size());
        Class<?> keyType = null;
        Class<?> valueType = null;
        if (this.targetMapClass != null) {
            keyType = GenericCollectionTypeResolver.getMapKeyType(this.targetMapClass);
            valueType = GenericCollectionTypeResolver.getMapValueType(this.targetMapClass);
        }
        if (keyType != null || valueType != null) {
            TypeConverter converter = this.getBeanTypeConverter();
            for (Map.Entry<?, ?> entry : this.sourceMap.entrySet()) {
                Object convertedKey = converter.convertIfNecessary(entry.getKey(), keyType);
                Object convertedValue = converter.convertIfNecessary(entry.getValue(), valueType);
                result.put(convertedKey, convertedValue);
            }
        } else {
            result.putAll(this.sourceMap);
        }
        return result;
    }
}

