/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.AAA.beans.factory.support;

import java.lang.reflect.Method;
import org.springframework.AAA.beans.factory.BeanFactory;
import org.springframework.AAA.beans.factory.BeanFactoryAware;
import org.springframework.AAA.beans.factory.FactoryBean;
import org.springframework.AAA.beans.factory.config.BeanDefinition;
import org.springframework.AAA.beans.factory.config.BeanDefinitionHolder;
import org.springframework.AAA.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.AAA.beans.factory.config.DependencyDescriptor;
import org.springframework.AAA.beans.factory.support.AutowireCandidateResolver;
import org.springframework.AAA.beans.factory.support.RootBeanDefinition;
import org.springframework.AAA.core.ResolvableType;
import org.springframework.AAA.util.ClassUtils;

public class GenericTypeAwareAutowireCandidateResolver
implements AutowireCandidateResolver,
BeanFactoryAware {
    private BeanFactory beanFactory;

    @Override
    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    protected final BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    @Override
    public boolean isAutowireCandidate(BeanDefinitionHolder bdHolder, DependencyDescriptor descriptor) {
        if (!bdHolder.getBeanDefinition().isAutowireCandidate()) {
            return false;
        }
        return descriptor == null || this.checkGenericTypeMatch(bdHolder, descriptor);
    }

    protected boolean checkGenericTypeMatch(BeanDefinitionHolder bdHolder, DependencyDescriptor descriptor) {
        RootBeanDefinition dbd;
        ResolvableType dependencyType = descriptor.getResolvableType();
        if (dependencyType.getType() instanceof Class) {
            return true;
        }
        ResolvableType targetType = null;
        RootBeanDefinition rbd = null;
        if (bdHolder.getBeanDefinition() instanceof RootBeanDefinition) {
            rbd = (RootBeanDefinition)bdHolder.getBeanDefinition();
        }
        if (rbd != null && (targetType = this.getReturnTypeForFactoryMethod(rbd, descriptor)) == null && (dbd = this.getResolvedDecoratedDefinition(rbd)) != null) {
            targetType = this.getReturnTypeForFactoryMethod(dbd, descriptor);
        }
        if (targetType == null) {
            Class<?> beanClass;
            Class<?> beanType;
            if (this.beanFactory != null && (beanType = this.beanFactory.getType(bdHolder.getBeanName())) != null) {
                targetType = ResolvableType.forClass(ClassUtils.getUserClass(beanType));
            }
            if (targetType == null && rbd != null && rbd.hasBeanClass() && rbd.getFactoryMethodName() == null && !FactoryBean.class.isAssignableFrom(beanClass = rbd.getBeanClass())) {
                targetType = ResolvableType.forClass(ClassUtils.getUserClass(beanClass));
            }
        }
        if (targetType == null || descriptor.fallbackMatchAllowed() && targetType.hasUnresolvableGenerics()) {
            return true;
        }
        return dependencyType.isAssignableFrom(targetType);
    }

    protected RootBeanDefinition getResolvedDecoratedDefinition(RootBeanDefinition rbd) {
        BeanDefinition dbd;
        ConfigurableListableBeanFactory clbf;
        BeanDefinitionHolder decDef = rbd.getDecoratedDefinition();
        if (decDef != null && this.beanFactory instanceof ConfigurableListableBeanFactory && (clbf = (ConfigurableListableBeanFactory)this.beanFactory).containsBeanDefinition(decDef.getBeanName()) && (dbd = clbf.getMergedBeanDefinition(decDef.getBeanName())) instanceof RootBeanDefinition) {
            return (RootBeanDefinition)dbd;
        }
        return null;
    }

    protected ResolvableType getReturnTypeForFactoryMethod(RootBeanDefinition rbd, DependencyDescriptor descriptor) {
        Class<?> preResolved = rbd.resolvedFactoryMethodReturnType;
        if (preResolved != null) {
            return ResolvableType.forClass(preResolved);
        }
        Method resolvedFactoryMethod = rbd.getResolvedFactoryMethod();
        if (resolvedFactoryMethod != null && descriptor.getDependencyType().isAssignableFrom(resolvedFactoryMethod.getReturnType())) {
            return ResolvableType.forMethodReturnType(resolvedFactoryMethod);
        }
        return null;
    }

    @Override
    public Object getSuggestedValue(DependencyDescriptor descriptor) {
        return null;
    }

    @Override
    public Object getLazyResolutionProxyIfNecessary(DependencyDescriptor descriptor, String beanName) {
        return null;
    }
}

