/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.AAA.cache.annotation;

import java.util.Collection;
import org.springframework.AAA.beans.factory.annotation.Autowired;
import org.springframework.AAA.cache.CacheManager;
import org.springframework.AAA.cache.annotation.CachingConfigurer;
import org.springframework.AAA.cache.annotation.EnableCaching;
import org.springframework.AAA.cache.interceptor.CacheErrorHandler;
import org.springframework.AAA.cache.interceptor.CacheResolver;
import org.springframework.AAA.cache.interceptor.KeyGenerator;
import org.springframework.AAA.context.annotation.Configuration;
import org.springframework.AAA.context.annotation.ImportAware;
import org.springframework.AAA.core.annotation.AnnotationAttributes;
import org.springframework.AAA.core.type.AnnotationMetadata;
import org.springframework.AAA.util.CollectionUtils;

@Configuration
public abstract class AbstractCachingConfiguration
implements ImportAware {
    protected AnnotationAttributes enableCaching;
    protected CacheManager cacheManager;
    protected CacheResolver cacheResolver;
    protected KeyGenerator keyGenerator;
    protected CacheErrorHandler errorHandler;

    @Override
    public void setImportMetadata(AnnotationMetadata importMetadata) {
        this.enableCaching = AnnotationAttributes.fromMap(importMetadata.getAnnotationAttributes(EnableCaching.class.getName(), false));
        if (this.enableCaching == null) {
            throw new IllegalArgumentException("@EnableCaching is not present on importing class " + importMetadata.getClassName());
        }
    }

    @Autowired(required=false)
    void setConfigurers(Collection<CachingConfigurer> configurers) {
        if (CollectionUtils.isEmpty(configurers)) {
            return;
        }
        if (configurers.size() > 1) {
            throw new IllegalStateException(configurers.size() + " implementations of " + "CachingConfigurer were found when only 1 was expected. " + "Refactor the configuration such that CachingConfigurer is " + "implemented only once or not at all.");
        }
        CachingConfigurer configurer = configurers.iterator().next();
        this.useCachingConfigurer(configurer);
    }

    protected void useCachingConfigurer(CachingConfigurer config) {
        this.cacheManager = config.cacheManager();
        this.cacheResolver = config.cacheResolver();
        this.keyGenerator = config.keyGenerator();
        this.errorHandler = config.errorHandler();
    }
}

