/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.AAA.cache.annotation;

import java.util.ArrayList;
import org.springframework.AAA.cache.annotation.EnableCaching;
import org.springframework.AAA.cache.annotation.ProxyCachingConfiguration;
import org.springframework.AAA.context.annotation.AdviceMode;
import org.springframework.AAA.context.annotation.AdviceModeImportSelector;
import org.springframework.AAA.context.annotation.AutoProxyRegistrar;
import org.springframework.AAA.util.ClassUtils;

public class CachingConfigurationSelector
extends AdviceModeImportSelector<EnableCaching> {
    private static final String PROXY_JCACHE_CONFIGURATION_CLASS = "org.springframework.AAA.cache.jcache.config.ProxyJCacheConfiguration";
    private static final String CACHE_ASPECT_CONFIGURATION_CLASS_NAME = "org.springframework.AAA.cache.aspectj.AspectJCachingConfiguration";
    private static final String JCACHE_ASPECT_CONFIGURATION_CLASS_NAME = "org.springframework.AAA.cache.aspectj.AspectJJCacheConfiguration";
    private static final boolean jsr107Present = ClassUtils.isPresent("javax.cache.Cache", CachingConfigurationSelector.class.getClassLoader());
    private static final boolean jCacheImplPresent = ClassUtils.isPresent("org.springframework.AAA.cache.jcache.config.ProxyJCacheConfiguration", CachingConfigurationSelector.class.getClassLoader());

    @Override
    public String[] selectImports(AdviceMode adviceMode) {
        switch (adviceMode) {
            case PROXY: {
                return this.getProxyImports();
            }
            case ASPECTJ: {
                return this.getAspectJImports();
            }
        }
        return null;
    }

    private String[] getProxyImports() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(AutoProxyRegistrar.class.getName());
        result.add(ProxyCachingConfiguration.class.getName());
        if (jsr107Present && jCacheImplPresent) {
            result.add(PROXY_JCACHE_CONFIGURATION_CLASS);
        }
        return result.toArray(new String[result.size()]);
    }

    private String[] getAspectJImports() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(CACHE_ASPECT_CONFIGURATION_CLASS_NAME);
        if (jsr107Present && jCacheImplPresent) {
            result.add(JCACHE_ASPECT_CONFIGURATION_CLASS_NAME);
        }
        return result.toArray(new String[result.size()]);
    }
}

