/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.AAA.context.annotation;

import java.lang.annotation.Annotation;
import org.springframework.AAA.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.AAA.beans.factory.config.BeanDefinition;
import org.springframework.AAA.context.annotation.AnnotationConfigUtils;
import org.springframework.AAA.context.annotation.Scope;
import org.springframework.AAA.context.annotation.ScopeMetadata;
import org.springframework.AAA.context.annotation.ScopeMetadataResolver;
import org.springframework.AAA.context.annotation.ScopedProxyMode;
import org.springframework.AAA.core.annotation.AnnotationAttributes;
import org.springframework.AAA.core.type.AnnotatedTypeMetadata;
import org.springframework.AAA.util.Assert;

public class AnnotationScopeMetadataResolver
implements ScopeMetadataResolver {
    private final ScopedProxyMode defaultProxyMode;
    protected Class<? extends Annotation> scopeAnnotationType = Scope.class;

    public AnnotationScopeMetadataResolver() {
        this.defaultProxyMode = ScopedProxyMode.NO;
    }

    public AnnotationScopeMetadataResolver(ScopedProxyMode defaultProxyMode) {
        Assert.notNull((Object)defaultProxyMode, "'defaultProxyMode' must not be null");
        this.defaultProxyMode = defaultProxyMode;
    }

    public void setScopeAnnotationType(Class<? extends Annotation> scopeAnnotationType) {
        Assert.notNull(scopeAnnotationType, "'scopeAnnotationType' must not be null");
        this.scopeAnnotationType = scopeAnnotationType;
    }

    @Override
    public ScopeMetadata resolveScopeMetadata(BeanDefinition definition) {
        AnnotatedBeanDefinition annDef;
        AnnotationAttributes attributes;
        ScopeMetadata metadata = new ScopeMetadata();
        if (definition instanceof AnnotatedBeanDefinition && (attributes = AnnotationConfigUtils.attributesFor((AnnotatedTypeMetadata)(annDef = (AnnotatedBeanDefinition)definition).getMetadata(), this.scopeAnnotationType)) != null) {
            metadata.setScopeName(attributes.getString("value"));
            ScopedProxyMode proxyMode = (ScopedProxyMode)((Object)attributes.getEnum("proxyMode"));
            if (proxyMode == null || proxyMode == ScopedProxyMode.DEFAULT) {
                proxyMode = this.defaultProxyMode;
            }
            metadata.setScopedProxyMode(proxyMode);
        }
        return metadata;
    }
}

