/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.AAA.context.annotation;

import org.springframework.AAA.beans.factory.parsing.Problem;
import org.springframework.AAA.beans.factory.parsing.ProblemReporter;
import org.springframework.AAA.context.annotation.Configuration;
import org.springframework.AAA.context.annotation.ConfigurationClass;
import org.springframework.AAA.context.annotation.ConfigurationMethod;
import org.springframework.AAA.core.type.MethodMetadata;

final class BeanMethod
extends ConfigurationMethod {
    public BeanMethod(MethodMetadata metadata, ConfigurationClass configurationClass) {
        super(metadata, configurationClass);
    }

    @Override
    public void validate(ProblemReporter problemReporter) {
        if (this.getMetadata().isStatic()) {
            return;
        }
        if (this.configurationClass.getMetadata().isAnnotated(Configuration.class.getName()) && !this.getMetadata().isOverridable()) {
            problemReporter.error(new NonOverridableMethodError());
        }
    }

    private class NonOverridableMethodError
    extends Problem {
        public NonOverridableMethodError() {
            super(String.format("@Bean method '%s' must not be private or final; change the method's modifiers to continue", BeanMethod.this.getMetadata().getMethodName()), BeanMethod.this.getResourceLocation());
        }
    }
}

