/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.AAA.context.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.springframework.AAA.aop.TargetSource;
import org.springframework.AAA.aop.framework.ProxyFactory;
import org.springframework.AAA.beans.factory.annotation.QualifierAnnotationAutowireCandidateResolver;
import org.springframework.AAA.beans.factory.config.DependencyDescriptor;
import org.springframework.AAA.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.AAA.context.annotation.Lazy;
import org.springframework.AAA.core.MethodParameter;
import org.springframework.AAA.core.annotation.AnnotationUtils;
import org.springframework.AAA.util.Assert;

public class ContextAnnotationAutowireCandidateResolver
extends QualifierAnnotationAutowireCandidateResolver {
    @Override
    public Object getLazyResolutionProxyIfNecessary(DependencyDescriptor descriptor, String beanName) {
        return this.isLazy(descriptor) ? this.buildLazyResolutionProxy(descriptor, beanName) : null;
    }

    protected boolean isLazy(DependencyDescriptor descriptor) {
        Lazy lazy;
        Method method;
        for (Annotation ann : descriptor.getAnnotations()) {
            Lazy lazy2 = AnnotationUtils.getAnnotation(ann, Lazy.class);
            if (lazy2 == null || !lazy2.value()) continue;
            return true;
        }
        MethodParameter methodParam = descriptor.getMethodParameter();
        return methodParam != null && ((method = methodParam.getMethod()) == null || Void.TYPE.equals(method.getReturnType())) && (lazy = AnnotationUtils.getAnnotation(methodParam.getAnnotatedElement(), Lazy.class)) != null && lazy.value();
    }

    protected Object buildLazyResolutionProxy(final DependencyDescriptor descriptor, final String beanName) {
        Assert.state(this.getBeanFactory() instanceof DefaultListableBeanFactory, "BeanFactory needs to be a DefaultListableBeanFactory");
        final DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)this.getBeanFactory();
        TargetSource ts = new TargetSource(){

            @Override
            public Class<?> getTargetClass() {
                return descriptor.getDependencyType();
            }

            @Override
            public boolean isStatic() {
                return false;
            }

            @Override
            public Object getTarget() {
                return beanFactory.doResolveDependency(descriptor, beanName, null, null);
            }

            @Override
            public void releaseTarget(Object target) {
            }
        };
        ProxyFactory pf = new ProxyFactory();
        pf.setTargetSource(ts);
        Class<?> dependencyType = descriptor.getDependencyType();
        if (dependencyType.isInterface()) {
            pf.addInterface(dependencyType);
        }
        return pf.getProxy(beanFactory.getBeanClassLoader());
    }
}

