/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.AAA.context.annotation;

import org.springframework.AAA.beans.factory.BeanClassLoaderAware;
import org.springframework.AAA.beans.factory.annotation.Autowired;
import org.springframework.AAA.context.annotation.AnnotationConfigUtils;
import org.springframework.AAA.context.annotation.Bean;
import org.springframework.AAA.context.annotation.Configuration;
import org.springframework.AAA.context.annotation.EnableLoadTimeWeaving;
import org.springframework.AAA.context.annotation.ImportAware;
import org.springframework.AAA.context.annotation.LoadTimeWeavingConfigurer;
import org.springframework.AAA.context.annotation.Role;
import org.springframework.AAA.context.weaving.AspectJWeavingEnabler;
import org.springframework.AAA.context.weaving.DefaultContextLoadTimeWeaver;
import org.springframework.AAA.core.annotation.AnnotationAttributes;
import org.springframework.AAA.core.type.AnnotatedTypeMetadata;
import org.springframework.AAA.core.type.AnnotationMetadata;
import org.springframework.AAA.instrument.classloading.LoadTimeWeaver;

@Configuration
public class LoadTimeWeavingConfiguration
implements ImportAware,
BeanClassLoaderAware {
    private AnnotationAttributes enableLTW;
    private LoadTimeWeavingConfigurer ltwConfigurer;
    private ClassLoader beanClassLoader;

    @Override
    public void setImportMetadata(AnnotationMetadata importMetadata) {
        this.enableLTW = AnnotationConfigUtils.attributesFor((AnnotatedTypeMetadata)importMetadata, EnableLoadTimeWeaving.class);
        if (this.enableLTW == null) {
            throw new IllegalArgumentException("@EnableLoadTimeWeaving is not present on importing class " + importMetadata.getClassName());
        }
    }

    @Autowired(required=false)
    public void setLoadTimeWeavingConfigurer(LoadTimeWeavingConfigurer ltwConfigurer) {
        this.ltwConfigurer = ltwConfigurer;
    }

    @Override
    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    @Bean(name={"loadTimeWeaver"})
    @Role(value=2)
    public LoadTimeWeaver loadTimeWeaver() {
        LoadTimeWeaver loadTimeWeaver = null;
        if (this.ltwConfigurer != null) {
            loadTimeWeaver = this.ltwConfigurer.getLoadTimeWeaver();
        }
        if (loadTimeWeaver == null) {
            loadTimeWeaver = new DefaultContextLoadTimeWeaver(this.beanClassLoader);
        }
        EnableLoadTimeWeaving.AspectJWeaving aspectJWeaving = (EnableLoadTimeWeaving.AspectJWeaving)((Object)this.enableLTW.getEnum("aspectjWeaving"));
        switch (aspectJWeaving) {
            case DISABLED: {
                break;
            }
            case AUTODETECT: {
                if (this.beanClassLoader.getResource("META-INF/aop.xml") == null) break;
                AspectJWeavingEnabler.enableAspectJWeaving(loadTimeWeaver, this.beanClassLoader);
                break;
            }
            case ENABLED: {
                AspectJWeavingEnabler.enableAspectJWeaving(loadTimeWeaver, this.beanClassLoader);
            }
        }
        return loadTimeWeaver;
    }
}

