/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.AAA.context.weaving;

import org.springframework.AAA.beans.BeansException;
import org.springframework.AAA.beans.factory.BeanFactory;
import org.springframework.AAA.beans.factory.BeanFactoryAware;
import org.springframework.AAA.beans.factory.config.BeanPostProcessor;
import org.springframework.AAA.context.weaving.LoadTimeWeaverAware;
import org.springframework.AAA.instrument.classloading.LoadTimeWeaver;
import org.springframework.AAA.util.Assert;

public class LoadTimeWeaverAwareProcessor
implements BeanPostProcessor,
BeanFactoryAware {
    private LoadTimeWeaver loadTimeWeaver;
    private BeanFactory beanFactory;

    public LoadTimeWeaverAwareProcessor() {
    }

    public LoadTimeWeaverAwareProcessor(LoadTimeWeaver loadTimeWeaver) {
        this.loadTimeWeaver = loadTimeWeaver;
    }

    public LoadTimeWeaverAwareProcessor(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Override
    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof LoadTimeWeaverAware) {
            LoadTimeWeaver ltw = this.loadTimeWeaver;
            if (ltw == null) {
                Assert.state(this.beanFactory != null, "BeanFactory required if no LoadTimeWeaver explicitly specified");
                ltw = this.beanFactory.getBean("loadTimeWeaver", LoadTimeWeaver.class);
            }
            ((LoadTimeWeaverAware)bean).setLoadTimeWeaver(ltw);
        }
        return bean;
    }

    @Override
    public Object postProcessAfterInitialization(Object bean, String name) {
        return bean;
    }
}

