/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.AAA.core;

import java.util.HashSet;
import java.util.Set;
import org.springframework.AAA.lang.UsesJava7;
import org.springframework.AAA.util.Assert;
import org.springframework.AAA.util.ClassUtils;

@UsesJava7
public abstract class DecoratingClassLoader
extends ClassLoader {
    protected static final boolean parallelCapableClassLoaderAvailable = ClassUtils.hasMethod(ClassLoader.class, "registerAsParallelCapable", new Class[0]);
    private final Set<String> excludedPackages = new HashSet<String>();
    private final Set<String> excludedClasses = new HashSet<String>();
    private final Object exclusionMonitor = new Object();

    public DecoratingClassLoader() {
    }

    public DecoratingClassLoader(ClassLoader parent) {
        super(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void excludePackage(String packageName) {
        Assert.notNull(packageName, "Package name must not be null");
        Object object = this.exclusionMonitor;
        synchronized (object) {
            this.excludedPackages.add(packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void excludeClass(String className) {
        Assert.notNull(className, "Class name must not be null");
        Object object = this.exclusionMonitor;
        synchronized (object) {
            this.excludedClasses.add(className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isExcluded(String className) {
        Object object = this.exclusionMonitor;
        synchronized (object) {
            if (this.excludedClasses.contains(className)) {
                return true;
            }
            for (String packageName : this.excludedPackages) {
                if (!className.startsWith(packageName)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        if (parallelCapableClassLoaderAvailable) {
            ClassLoader.registerAsParallelCapable();
        }
    }
}

