/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.AAA.core.convert.support;

import java.util.Locale;
import java.util.UUID;
import org.springframework.AAA.core.convert.ConversionService;
import org.springframework.AAA.core.convert.converter.ConverterRegistry;
import org.springframework.AAA.core.convert.support.ArrayToArrayConverter;
import org.springframework.AAA.core.convert.support.ArrayToCollectionConverter;
import org.springframework.AAA.core.convert.support.ArrayToObjectConverter;
import org.springframework.AAA.core.convert.support.ArrayToStringConverter;
import org.springframework.AAA.core.convert.support.ByteBufferConverter;
import org.springframework.AAA.core.convert.support.CharacterToNumberFactory;
import org.springframework.AAA.core.convert.support.CollectionToArrayConverter;
import org.springframework.AAA.core.convert.support.CollectionToCollectionConverter;
import org.springframework.AAA.core.convert.support.CollectionToObjectConverter;
import org.springframework.AAA.core.convert.support.CollectionToStringConverter;
import org.springframework.AAA.core.convert.support.EnumToStringConverter;
import org.springframework.AAA.core.convert.support.FallbackObjectToStringConverter;
import org.springframework.AAA.core.convert.support.GenericConversionService;
import org.springframework.AAA.core.convert.support.IdToEntityConverter;
import org.springframework.AAA.core.convert.support.MapToMapConverter;
import org.springframework.AAA.core.convert.support.NumberToCharacterConverter;
import org.springframework.AAA.core.convert.support.NumberToNumberConverterFactory;
import org.springframework.AAA.core.convert.support.ObjectToArrayConverter;
import org.springframework.AAA.core.convert.support.ObjectToCollectionConverter;
import org.springframework.AAA.core.convert.support.ObjectToObjectConverter;
import org.springframework.AAA.core.convert.support.ObjectToOptionalConverter;
import org.springframework.AAA.core.convert.support.ObjectToStringConverter;
import org.springframework.AAA.core.convert.support.PropertiesToStringConverter;
import org.springframework.AAA.core.convert.support.StringToArrayConverter;
import org.springframework.AAA.core.convert.support.StringToBooleanConverter;
import org.springframework.AAA.core.convert.support.StringToCharacterConverter;
import org.springframework.AAA.core.convert.support.StringToCollectionConverter;
import org.springframework.AAA.core.convert.support.StringToEnumConverterFactory;
import org.springframework.AAA.core.convert.support.StringToLocaleConverter;
import org.springframework.AAA.core.convert.support.StringToNumberConverterFactory;
import org.springframework.AAA.core.convert.support.StringToPropertiesConverter;
import org.springframework.AAA.core.convert.support.StringToUUIDConverter;
import org.springframework.AAA.core.convert.support.ZoneIdToTimeZoneConverter;
import org.springframework.AAA.core.convert.support.ZonedDateTimeToCalendarConverter;
import org.springframework.AAA.util.ClassUtils;

public class DefaultConversionService
extends GenericConversionService {
    private static final boolean javaUtilOptionalClassAvailable = ClassUtils.isPresent("java.util.Optional", DefaultConversionService.class.getClassLoader());
    private static final boolean jsr310Available = ClassUtils.isPresent("java.time.ZoneId", DefaultConversionService.class.getClassLoader());

    public DefaultConversionService() {
        DefaultConversionService.addDefaultConverters(this);
    }

    public static void addDefaultConverters(ConverterRegistry converterRegistry) {
        DefaultConversionService.addScalarConverters(converterRegistry);
        DefaultConversionService.addCollectionConverters(converterRegistry);
        converterRegistry.addConverter(new ByteBufferConverter((ConversionService)((Object)converterRegistry)));
        if (jsr310Available) {
            Jsr310ConverterRegistrar.registerZoneIdConverters(converterRegistry);
        }
        converterRegistry.addConverter(new ObjectToObjectConverter());
        converterRegistry.addConverter(new IdToEntityConverter((ConversionService)((Object)converterRegistry)));
        converterRegistry.addConverter(new FallbackObjectToStringConverter());
        if (javaUtilOptionalClassAvailable) {
            converterRegistry.addConverter(new ObjectToOptionalConverter((ConversionService)((Object)converterRegistry)));
        }
    }

    private static void addScalarConverters(ConverterRegistry converterRegistry) {
        converterRegistry.addConverterFactory(new NumberToNumberConverterFactory());
        converterRegistry.addConverterFactory(new StringToNumberConverterFactory());
        converterRegistry.addConverter(Number.class, String.class, new ObjectToStringConverter());
        converterRegistry.addConverter(new StringToCharacterConverter());
        converterRegistry.addConverter(Character.class, String.class, new ObjectToStringConverter());
        converterRegistry.addConverter(new NumberToCharacterConverter());
        converterRegistry.addConverterFactory(new CharacterToNumberFactory());
        converterRegistry.addConverter(new StringToBooleanConverter());
        converterRegistry.addConverter(Boolean.class, String.class, new ObjectToStringConverter());
        converterRegistry.addConverterFactory(new StringToEnumConverterFactory());
        converterRegistry.addConverter(Enum.class, String.class, new EnumToStringConverter((ConversionService)((Object)converterRegistry)));
        converterRegistry.addConverter(new StringToLocaleConverter());
        converterRegistry.addConverter(Locale.class, String.class, new ObjectToStringConverter());
        converterRegistry.addConverter(new StringToPropertiesConverter());
        converterRegistry.addConverter(new PropertiesToStringConverter());
        converterRegistry.addConverter(new StringToUUIDConverter());
        converterRegistry.addConverter(UUID.class, String.class, new ObjectToStringConverter());
    }

    private static void addCollectionConverters(ConverterRegistry converterRegistry) {
        ConversionService conversionService = (ConversionService)((Object)converterRegistry);
        converterRegistry.addConverter(new ArrayToCollectionConverter(conversionService));
        converterRegistry.addConverter(new CollectionToArrayConverter(conversionService));
        converterRegistry.addConverter(new ArrayToArrayConverter(conversionService));
        converterRegistry.addConverter(new CollectionToCollectionConverter(conversionService));
        converterRegistry.addConverter(new MapToMapConverter(conversionService));
        converterRegistry.addConverter(new ArrayToStringConverter(conversionService));
        converterRegistry.addConverter(new StringToArrayConverter(conversionService));
        converterRegistry.addConverter(new ArrayToObjectConverter(conversionService));
        converterRegistry.addConverter(new ObjectToArrayConverter(conversionService));
        converterRegistry.addConverter(new CollectionToStringConverter(conversionService));
        converterRegistry.addConverter(new StringToCollectionConverter(conversionService));
        converterRegistry.addConverter(new CollectionToObjectConverter(conversionService));
        converterRegistry.addConverter(new ObjectToCollectionConverter(conversionService));
    }

    private static final class Jsr310ConverterRegistrar {
        private Jsr310ConverterRegistrar() {
        }

        public static void registerZoneIdConverters(ConverterRegistry converterRegistry) {
            converterRegistry.addConverter(new ZoneIdToTimeZoneConverter());
            converterRegistry.addConverter(new ZonedDateTimeToCalendarConverter());
        }
    }
}

