/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.AAA.core.convert.support;

import java.io.StringWriter;
import java.util.Collections;
import java.util.Set;
import org.springframework.AAA.core.convert.TypeDescriptor;
import org.springframework.AAA.core.convert.converter.ConditionalGenericConverter;
import org.springframework.AAA.core.convert.converter.GenericConverter;
import org.springframework.AAA.core.convert.support.ObjectToObjectConverter;
import org.springframework.AAA.util.ClassUtils;

final class FallbackObjectToStringConverter
implements ConditionalGenericConverter {
    FallbackObjectToStringConverter() {
    }

    @Override
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Object.class, String.class));
    }

    @Override
    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        Class<?> sourceClass = sourceType.getObjectType();
        if (String.class.equals(sourceClass)) {
            return false;
        }
        return CharSequence.class.isAssignableFrom(sourceClass) || StringWriter.class.isAssignableFrom(sourceClass) || ObjectToObjectConverter.getOfMethod(sourceClass, String.class) != null || ClassUtils.getConstructorIfAvailable(sourceClass, String.class) != null;
    }

    @Override
    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        return source != null ? source.toString() : null;
    }
}

