/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.AAA.core.convert.support;

import java.lang.reflect.Array;
import java.util.Collections;
import java.util.Set;
import org.springframework.AAA.core.convert.ConversionService;
import org.springframework.AAA.core.convert.TypeDescriptor;
import org.springframework.AAA.core.convert.converter.ConditionalGenericConverter;
import org.springframework.AAA.core.convert.converter.GenericConverter;
import org.springframework.AAA.util.StringUtils;

final class StringToArrayConverter
implements ConditionalGenericConverter {
    private final ConversionService conversionService;

    public StringToArrayConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(String.class, Object[].class));
    }

    @Override
    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return this.conversionService.canConvert(sourceType, targetType.getElementTypeDescriptor());
    }

    @Override
    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        String string = (String)source;
        String[] fields = StringUtils.commaDelimitedListToStringArray(string);
        Object target = Array.newInstance(targetType.getElementTypeDescriptor().getType(), fields.length);
        for (int i = 0; i < fields.length; ++i) {
            String sourceElement = fields[i];
            Object targetElement = this.conversionService.convert(sourceElement.trim(), sourceType, targetType.getElementTypeDescriptor());
            Array.set(target, i, targetElement);
        }
        return target;
    }
}

