/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.AAA.core.type.classreading;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.AAA.asm.AnnotationVisitor;
import org.springframework.AAA.asm.MethodVisitor;
import org.springframework.AAA.asm.Type;
import org.springframework.AAA.core.annotation.AnnotationAttributes;
import org.springframework.AAA.core.type.MethodMetadata;
import org.springframework.AAA.core.type.classreading.AnnotationAttributesReadingVisitor;
import org.springframework.AAA.core.type.classreading.AnnotationReadingVisitorUtils;
import org.springframework.AAA.util.LinkedMultiValueMap;
import org.springframework.AAA.util.MultiValueMap;

public class MethodMetadataReadingVisitor
extends MethodVisitor
implements MethodMetadata {
    protected final String name;
    protected final int access;
    protected final String declaringClassName;
    protected final ClassLoader classLoader;
    protected final Set<MethodMetadata> methodMetadataSet;
    protected final Map<String, Set<String>> metaAnnotationMap = new LinkedHashMap<String, Set<String>>(4);
    protected final LinkedMultiValueMap<String, AnnotationAttributes> attributesMap = new LinkedMultiValueMap(4);

    public MethodMetadataReadingVisitor(String name, int access, String declaringClassName, ClassLoader classLoader, Set<MethodMetadata> methodMetadataSet) {
        super(327680);
        this.name = name;
        this.access = access;
        this.declaringClassName = declaringClassName;
        this.classLoader = classLoader;
        this.methodMetadataSet = methodMetadataSet;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        String className = Type.getType(desc).getClassName();
        this.methodMetadataSet.add(this);
        return new AnnotationAttributesReadingVisitor(className, this.attributesMap, this.metaAnnotationMap, this.classLoader);
    }

    @Override
    public String getMethodName() {
        return this.name;
    }

    @Override
    public boolean isStatic() {
        return (this.access & 8) != 0;
    }

    @Override
    public boolean isFinal() {
        return (this.access & 0x10) != 0;
    }

    @Override
    public boolean isOverridable() {
        return !this.isStatic() && !this.isFinal() && (this.access & 2) == 0;
    }

    @Override
    public boolean isAnnotated(String annotationType) {
        return this.attributesMap.containsKey(annotationType);
    }

    @Override
    public Map<String, Object> getAnnotationAttributes(String annotationType) {
        return this.getAnnotationAttributes(annotationType, false);
    }

    @Override
    public Map<String, Object> getAnnotationAttributes(String annotationType, boolean classValuesAsString) {
        AnnotationAttributes raw = AnnotationReadingVisitorUtils.getMergedAnnotationAttributes(this.attributesMap, this.metaAnnotationMap, annotationType);
        return AnnotationReadingVisitorUtils.convertClassValues(this.classLoader, raw, classValuesAsString);
    }

    @Override
    public MultiValueMap<String, Object> getAllAnnotationAttributes(String annotationType) {
        return this.getAllAnnotationAttributes(annotationType, false);
    }

    @Override
    public MultiValueMap<String, Object> getAllAnnotationAttributes(String annotationType, boolean classValuesAsString) {
        if (!this.attributesMap.containsKey(annotationType)) {
            return null;
        }
        LinkedMultiValueMap<String, Object> allAttributes = new LinkedMultiValueMap<String, Object>();
        Iterator iterator = this.attributesMap.get(annotationType).iterator();
        while (iterator.hasNext()) {
            AnnotationAttributes annotationAttributes = (AnnotationAttributes)iterator.next();
            for (Map.Entry entry : AnnotationReadingVisitorUtils.convertClassValues(this.classLoader, annotationAttributes, classValuesAsString).entrySet()) {
                allAttributes.add((String)entry.getKey(), entry.getValue());
            }
        }
        return allAttributes;
    }

    @Override
    public String getDeclaringClassName() {
        return this.declaringClassName;
    }
}

