/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.AAA.expression.spel.support;

import java.lang.reflect.Constructor;
import org.springframework.AAA.expression.AccessException;
import org.springframework.AAA.expression.ConstructorExecutor;
import org.springframework.AAA.expression.EvaluationContext;
import org.springframework.AAA.expression.TypedValue;
import org.springframework.AAA.expression.spel.support.ReflectionHelper;
import org.springframework.AAA.util.ReflectionUtils;

public class ReflectiveConstructorExecutor
implements ConstructorExecutor {
    private final Constructor<?> ctor;
    private final Integer varargsPosition;

    public ReflectiveConstructorExecutor(Constructor<?> ctor) {
        this.ctor = ctor;
        if (ctor.isVarArgs()) {
            Class<?>[] paramTypes = ctor.getParameterTypes();
            this.varargsPosition = paramTypes.length - 1;
        } else {
            this.varargsPosition = null;
        }
    }

    @Override
    public TypedValue execute(EvaluationContext context, Object ... arguments) throws AccessException {
        try {
            if (arguments != null) {
                ReflectionHelper.convertArguments(context.getTypeConverter(), arguments, this.ctor, this.varargsPosition);
            }
            if (this.ctor.isVarArgs()) {
                arguments = ReflectionHelper.setupArgumentsForVarargsInvocation(this.ctor.getParameterTypes(), arguments);
            }
            ReflectionUtils.makeAccessible(this.ctor);
            return new TypedValue(this.ctor.newInstance(arguments));
        }
        catch (Exception ex) {
            throw new AccessException("Problem invoking constructor: " + this.ctor, ex);
        }
    }

    public Constructor<?> getConstructor() {
        return this.ctor;
    }
}

