/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.AAA.format.support;

import org.springframework.AAA.core.convert.support.DefaultConversionService;
import org.springframework.AAA.format.FormatterRegistry;
import org.springframework.AAA.format.datetime.DateFormatterRegistrar;
import org.springframework.AAA.format.datetime.joda.JodaTimeFormatterRegistrar;
import org.springframework.AAA.format.datetime.standard.DateTimeFormatterRegistrar;
import org.springframework.AAA.format.number.NumberFormatAnnotationFormatterFactory;
import org.springframework.AAA.format.support.FormattingConversionService;
import org.springframework.AAA.util.ClassUtils;
import org.springframework.AAA.util.StringValueResolver;

public class DefaultFormattingConversionService
extends FormattingConversionService {
    private static final boolean jsr310Present = ClassUtils.isPresent("java.time.LocalDate", DefaultFormattingConversionService.class.getClassLoader());
    private static final boolean jodaTimePresent = ClassUtils.isPresent("org.joda.time.LocalDate", DefaultFormattingConversionService.class.getClassLoader());

    public DefaultFormattingConversionService() {
        this(null, true);
    }

    public DefaultFormattingConversionService(boolean registerDefaultFormatters) {
        this(null, registerDefaultFormatters);
    }

    public DefaultFormattingConversionService(StringValueResolver embeddedValueResolver, boolean registerDefaultFormatters) {
        this.setEmbeddedValueResolver(embeddedValueResolver);
        DefaultConversionService.addDefaultConverters(this);
        if (registerDefaultFormatters) {
            DefaultFormattingConversionService.addDefaultFormatters(this);
        }
    }

    public static void addDefaultFormatters(FormatterRegistry formatterRegistry) {
        formatterRegistry.addFormatterForFieldAnnotation(new NumberFormatAnnotationFormatterFactory());
        if (jsr310Present) {
            new DateTimeFormatterRegistrar().registerFormatters(formatterRegistry);
        }
        if (jodaTimePresent) {
            new JodaTimeFormatterRegistrar().registerFormatters(formatterRegistry);
        } else {
            new DateFormatterRegistrar().registerFormatters(formatterRegistry);
        }
    }
}

