/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.AAA.jndi;

import javax.naming.NamingException;
import org.springframework.AAA.core.env.PropertySource;
import org.springframework.AAA.jndi.JndiLocatorDelegate;

public class JndiPropertySource
extends PropertySource<JndiLocatorDelegate> {
    public JndiPropertySource(String name) {
        this(name, JndiLocatorDelegate.createDefaultResourceRefLocator());
    }

    public JndiPropertySource(String name, JndiLocatorDelegate jndiLocator) {
        super(name, jndiLocator);
    }

    @Override
    public Object getProperty(String name) {
        try {
            Object value = ((JndiLocatorDelegate)this.source).lookup(name);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("JNDI lookup for name [" + name + "] returned: [" + value + "]");
            }
            return value;
        }
        catch (NamingException ex) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("JNDI lookup for name [" + name + "] threw NamingException " + "with message: " + ex.getMessage() + ". Returning null.");
            }
            return null;
        }
    }
}

