/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.AAA.scheduling.annotation;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import org.aopalliance.aop.Advice;
import org.springframework.AAA.aop.Pointcut;
import org.springframework.AAA.aop.interceptor.AsyncUncaughtExceptionHandler;
import org.springframework.AAA.aop.interceptor.SimpleAsyncUncaughtExceptionHandler;
import org.springframework.AAA.aop.support.AbstractPointcutAdvisor;
import org.springframework.AAA.aop.support.ComposablePointcut;
import org.springframework.AAA.aop.support.annotation.AnnotationMatchingPointcut;
import org.springframework.AAA.beans.factory.BeanFactory;
import org.springframework.AAA.beans.factory.BeanFactoryAware;
import org.springframework.AAA.core.task.SimpleAsyncTaskExecutor;
import org.springframework.AAA.scheduling.annotation.AnnotationAsyncExecutionInterceptor;
import org.springframework.AAA.scheduling.annotation.Async;
import org.springframework.AAA.util.Assert;
import org.springframework.AAA.util.ClassUtils;

public class AsyncAnnotationAdvisor
extends AbstractPointcutAdvisor
implements BeanFactoryAware {
    private AsyncUncaughtExceptionHandler exceptionHandler;
    private Advice advice;
    private Pointcut pointcut;

    public AsyncAnnotationAdvisor() {
        this(null, null);
    }

    public AsyncAnnotationAdvisor(Executor executor, AsyncUncaughtExceptionHandler exceptionHandler) {
        LinkedHashSet<Class<? extends Annotation>> asyncAnnotationTypes = new LinkedHashSet<Class<? extends Annotation>>(2);
        asyncAnnotationTypes.add(Async.class);
        try {
            asyncAnnotationTypes.add(ClassUtils.forName("javax.ejb.Asynchronous", AsyncAnnotationAdvisor.class.getClassLoader()));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (executor == null) {
            executor = new SimpleAsyncTaskExecutor();
        }
        this.exceptionHandler = exceptionHandler != null ? exceptionHandler : new SimpleAsyncUncaughtExceptionHandler();
        this.advice = this.buildAdvice(executor, this.exceptionHandler);
        this.pointcut = this.buildPointcut(asyncAnnotationTypes);
    }

    public void setTaskExecutor(Executor executor) {
        this.advice = this.buildAdvice(executor, this.exceptionHandler);
    }

    public void setAsyncAnnotationType(Class<? extends Annotation> asyncAnnotationType) {
        Assert.notNull(asyncAnnotationType, "'asyncAnnotationType' must not be null");
        HashSet<Class<? extends Annotation>> asyncAnnotationTypes = new HashSet<Class<? extends Annotation>>();
        asyncAnnotationTypes.add(asyncAnnotationType);
        this.pointcut = this.buildPointcut(asyncAnnotationTypes);
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) {
        if (this.advice instanceof BeanFactoryAware) {
            ((BeanFactoryAware)((Object)this.advice)).setBeanFactory(beanFactory);
        }
    }

    @Override
    public Advice getAdvice() {
        return this.advice;
    }

    @Override
    public Pointcut getPointcut() {
        return this.pointcut;
    }

    protected Advice buildAdvice(Executor executor, AsyncUncaughtExceptionHandler exceptionHandler) {
        return new AnnotationAsyncExecutionInterceptor(executor, exceptionHandler);
    }

    protected Pointcut buildPointcut(Set<Class<? extends Annotation>> asyncAnnotationTypes) {
        ComposablePointcut result = null;
        for (Class<? extends Annotation> asyncAnnotationType : asyncAnnotationTypes) {
            AnnotationMatchingPointcut cpc = new AnnotationMatchingPointcut(asyncAnnotationType, true);
            AnnotationMatchingPointcut mpc = AnnotationMatchingPointcut.forMethodAnnotation(asyncAnnotationType);
            if (result == null) {
                result = new ComposablePointcut(cpc).union(mpc);
                continue;
            }
            result.union(cpc).union(mpc);
        }
        return result;
    }
}

