/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.AAA.scheduling.annotation;

import java.lang.annotation.Annotation;
import java.util.concurrent.Executor;
import org.springframework.AAA.aop.framework.AbstractAdvisingBeanPostProcessor;
import org.springframework.AAA.aop.interceptor.AsyncUncaughtExceptionHandler;
import org.springframework.AAA.beans.factory.BeanFactory;
import org.springframework.AAA.beans.factory.BeanFactoryAware;
import org.springframework.AAA.scheduling.annotation.AsyncAnnotationAdvisor;
import org.springframework.AAA.util.Assert;

public class AsyncAnnotationBeanPostProcessor
extends AbstractAdvisingBeanPostProcessor
implements BeanFactoryAware {
    private Class<? extends Annotation> asyncAnnotationType;
    private Executor executor;
    private AsyncUncaughtExceptionHandler exceptionHandler;

    public AsyncAnnotationBeanPostProcessor() {
        this.setBeforeExistingAdvisors(true);
    }

    public void setAsyncAnnotationType(Class<? extends Annotation> asyncAnnotationType) {
        Assert.notNull(asyncAnnotationType, "'asyncAnnotationType' must not be null");
        this.asyncAnnotationType = asyncAnnotationType;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public void setExceptionHandler(AsyncUncaughtExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) {
        AsyncAnnotationAdvisor advisor = new AsyncAnnotationAdvisor(this.executor, this.exceptionHandler);
        if (this.asyncAnnotationType != null) {
            advisor.setAsyncAnnotationType(this.asyncAnnotationType);
        }
        advisor.setBeanFactory(beanFactory);
        this.advisor = advisor;
    }
}

