/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.AAA.util.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.AAA.util.Assert;
import org.springframework.AAA.util.concurrent.FailureCallback;
import org.springframework.AAA.util.concurrent.ListenableFuture;
import org.springframework.AAA.util.concurrent.ListenableFutureCallback;
import org.springframework.AAA.util.concurrent.ListenableFutureTask;
import org.springframework.AAA.util.concurrent.SuccessCallback;

public class SettableListenableFuture<T>
implements ListenableFuture<T> {
    private final SettableTask<T> settableTask = new SettableTask();
    private final ListenableFutureTask<T> listenableFuture = new ListenableFutureTask<T>(this.settableTask);

    public boolean set(T value) {
        boolean success = this.settableTask.setValue(value);
        if (success) {
            this.listenableFuture.run();
        }
        return success;
    }

    public boolean setException(Throwable exception) {
        Assert.notNull(exception, "'exception' must not be null");
        boolean success = this.settableTask.setException(exception);
        if (success) {
            this.listenableFuture.run();
        }
        return success;
    }

    @Override
    public void addCallback(ListenableFutureCallback<? super T> callback) {
        this.listenableFuture.addCallback(callback);
    }

    @Override
    public void addCallback(SuccessCallback<? super T> successCallback, FailureCallback failureCallback) {
        this.listenableFuture.addCallback(successCallback, failureCallback);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.settableTask.setCancelled();
        boolean cancelled = this.listenableFuture.cancel(mayInterruptIfRunning);
        if (cancelled && mayInterruptIfRunning) {
            this.interruptTask();
        }
        return cancelled;
    }

    @Override
    public boolean isCancelled() {
        return this.listenableFuture.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.listenableFuture.isDone();
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        return (T)this.listenableFuture.get();
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)this.listenableFuture.get(timeout, unit);
    }

    protected void interruptTask() {
    }

    private static class SettableTask<T>
    implements Callable<T> {
        private static final String NO_VALUE = SettableListenableFuture.class.getName() + ".NO_VALUE";
        private final AtomicReference<Object> value = new AtomicReference<String>(NO_VALUE);
        private volatile boolean cancelled = false;

        private SettableTask() {
        }

        public boolean setValue(T value) {
            if (this.cancelled) {
                return false;
            }
            return this.value.compareAndSet(NO_VALUE, value);
        }

        public boolean setException(Throwable exception) {
            if (this.cancelled) {
                return false;
            }
            return this.value.compareAndSet(NO_VALUE, exception);
        }

        public void setCancelled() {
            this.cancelled = true;
        }

        @Override
        public T call() throws Exception {
            if (this.value.get() instanceof Exception) {
                throw (Exception)this.value.get();
            }
            return (T)this.value.get();
        }
    }
}

