/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.AAA.validation;

import org.springframework.AAA.beans.ConfigurablePropertyAccessor;
import org.springframework.AAA.beans.PropertyAccessorFactory;
import org.springframework.AAA.util.Assert;
import org.springframework.AAA.validation.AbstractPropertyBindingResult;

public class DirectFieldBindingResult
extends AbstractPropertyBindingResult {
    private final Object target;
    private final boolean autoGrowNestedPaths;
    private transient ConfigurablePropertyAccessor directFieldAccessor;

    public DirectFieldBindingResult(Object target, String objectName) {
        this(target, objectName, true);
    }

    public DirectFieldBindingResult(Object target, String objectName, boolean autoGrowNestedPaths) {
        super(objectName);
        this.target = target;
        this.autoGrowNestedPaths = autoGrowNestedPaths;
    }

    @Override
    public final Object getTarget() {
        return this.target;
    }

    @Override
    public final ConfigurablePropertyAccessor getPropertyAccessor() {
        if (this.directFieldAccessor == null) {
            this.directFieldAccessor = this.createDirectFieldAccessor();
            this.directFieldAccessor.setExtractOldValueForEditor(true);
            this.directFieldAccessor.setAutoGrowNestedPaths(this.autoGrowNestedPaths);
        }
        return this.directFieldAccessor;
    }

    protected ConfigurablePropertyAccessor createDirectFieldAccessor() {
        Assert.state(this.target != null, "Cannot access fields on null target instance '" + this.getObjectName() + "'!");
        return PropertyAccessorFactory.forDirectFieldAccess(this.target);
    }
}

