/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.model.parameter;

import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.model.parameter.TypeSource;
import org.mule.connectivity.util.ParserUtils;
import org.raml.v2.api.model.v10.datamodel.ArrayTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.UnionTypeDeclaration;

public class TypeDefinition {
    private final MediaType mediaType;
    private final TypeSource source;
    private final boolean required;
    private final String description;
    private final boolean unionType;
    private final boolean arrayType;
    private final String defaultValue;
    private final String example;
    private final String annotatedDisplayName;

    public TypeDefinition(TypeDeclaration typeDeclaration, TypeSource source, String mediaType) {
        this.mediaType = mediaType == null ? null : MediaType.valueOf((String)mediaType);
        this.source = source;
        this.defaultValue = TypeDefinition.getTypeDeclarationDefaultValue(typeDeclaration);
        this.required = typeDeclaration.required();
        this.example = typeDeclaration.example() == null ? null : typeDeclaration.example().value();
        this.description = typeDeclaration.description() == null ? null : StringUtils.trimToNull((String)typeDeclaration.description().value());
        this.unionType = typeDeclaration instanceof UnionTypeDeclaration;
        this.arrayType = typeDeclaration instanceof ArrayTypeDeclaration;
        this.annotatedDisplayName = ParserUtils.getAnnotatedParameterName(typeDeclaration);
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public TypeSource getSource() {
        return this.source;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isUnionType() {
        return this.unionType;
    }

    public boolean isArrayType() {
        return this.arrayType;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getExample() {
        return this.example;
    }

    private static String getTypeDeclarationDefaultValue(TypeDeclaration typeDeclaration) {
        try {
            String defaultValue = typeDeclaration.defaultValue();
            return StringUtils.isNotBlank((CharSequence)defaultValue) ? defaultValue : null;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public String getAnnotatedDisplayName() {
        return this.annotatedDisplayName;
    }
}

