/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.model.operation;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mule.connectivity.exception.DuplicatedParameterNameException;
import org.mule.connectivity.model.metadata.TypeDefinitionFactory;
import org.mule.connectivity.model.parameter.ImplicitUriParameterDeclaration;
import org.mule.connectivity.model.parameter.PrimitiveTypeSource;
import org.mule.connectivity.model.parameter.TypeDefinition;
import org.mule.connectivity.util.ParserUtils;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.methods.Method;
import org.raml.v2.api.model.v10.resources.Resource;

public class Operation {
    private final String friendlyName;
    private final String annotatedDisplayName;
    private final String description;
    private String canonicalName;
    private final Map<String, TypeDefinition> uriParameters;
    private final Map<String, TypeDefinition> queryParameters;
    private final Map<String, TypeDefinition> headers;
    private final Map<String, TypeDefinition> parameters;
    private final TypeDefinition inputMetadata;
    private final TypeDefinition outputMetadata;
    private final String httpMethod;
    private final String uri;

    public Operation(Method method) throws DuplicatedParameterNameException {
        this.friendlyName = ParserUtils.getMethodDisplayName(method);
        this.annotatedDisplayName = ParserUtils.getAnnotatedOperationName(method);
        this.description = ParserUtils.getMethodDescription(method);
        this.canonicalName = ParserUtils.getCanonicalOperationName(method, this);
        this.httpMethod = method.method();
        this.uri = method.resource().resourcePath();
        this.uriParameters = this.buildUriParams(method);
        this.queryParameters = this.buildQueryParams(method);
        this.headers = this.buildHeaders(method);
        this.parameters = this.buildParameters();
        TypeDefinitionFactory typeDefinitionFactory = new TypeDefinitionFactory(method);
        this.inputMetadata = typeDefinitionFactory.constructInputMetadata();
        this.outputMetadata = typeDefinitionFactory.constructOutputMetadata();
    }

    private Map<String, TypeDefinition> buildParameters() throws DuplicatedParameterNameException {
        this.validateParameterNames(this.queryParameters, this.uriParameters, this.headers);
        return new ImmutableMap.Builder().putAll(this.queryParameters).putAll(this.uriParameters).putAll(this.headers).build();
    }

    private void validateParameterNames(Map<String, TypeDefinition> ... parameterSources) throws DuplicatedParameterNameException {
        ArrayList<String> keys = new ArrayList<String>();
        for (Map<String, TypeDefinition> parameterSource : parameterSources) {
            for (String parameterName : parameterSource.keySet()) {
                if (keys.stream().anyMatch(str -> str.equals(parameterName))) {
                    throw new DuplicatedParameterNameException(parameterName, this);
                }
                keys.add(parameterName);
            }
        }
    }

    private Map<String, TypeDefinition> buildQueryParams(Method method) {
        return Operation.getParameterList(method.queryParameters());
    }

    private Map<String, TypeDefinition> buildUriParams(Method method) throws DuplicatedParameterNameException {
        Resource resource;
        ArrayList<Map<String, TypeDefinition>> maps = new ArrayList<Map<String, TypeDefinition>>();
        Map<String, TypeDefinition> implicitParams = this.getImplicitParameterList(resource);
        for (resource = method.resource(); resource != null; resource = resource.parentResource()) {
            maps.add(0, Operation.getParameterList(resource.uriParameters()));
        }
        ImmutableMap.Builder mapBuilder = new ImmutableMap.Builder();
        for (Map map : maps) {
            this.validateParameterNames(new Map[]{mapBuilder.build(), map});
            mapBuilder.putAll(map);
        }
        for (String string : implicitParams.keySet()) {
            if (mapBuilder.build().containsKey((Object)string)) continue;
            mapBuilder.put((Object)string, (Object)implicitParams.get(string));
        }
        return mapBuilder.build();
    }

    private Map<String, TypeDefinition> getImplicitParameterList(Resource resource) {
        HashMap<String, TypeDefinition> implicitParams = new HashMap<String, TypeDefinition>();
        Pattern pattern = Pattern.compile(".*?\\{([^\\}]*?)\\}");
        Matcher matcher = pattern.matcher(resource.resourcePath());
        while (matcher.find()) {
            String uriParam = matcher.group(1);
            ImplicitUriParameterDeclaration implicitParam = new ImplicitUriParameterDeclaration(uriParam);
            TypeDefinition td = new TypeDefinition((TypeDeclaration)implicitParam, new PrimitiveTypeSource(PrimitiveTypeSource.PrimitiveType.STRING), null);
            implicitParams.put(uriParam, td);
        }
        return implicitParams;
    }

    private Map<String, TypeDefinition> buildHeaders(Method method) {
        return Operation.getParameterList(method.headers());
    }

    public static Map<String, TypeDefinition> getParameterList(List<TypeDeclaration> typeDeclarationParameters) {
        ImmutableMap.Builder mapBuilder = new ImmutableMap.Builder();
        for (TypeDeclaration typeDeclaration : typeDeclarationParameters) {
            mapBuilder.put((Object)typeDeclaration.name(), (Object)TypeDefinitionFactory.getTypeDefinition(typeDeclaration));
        }
        return mapBuilder.build();
    }

    public Map<String, TypeDefinition> getQueryParameters() {
        return this.queryParameters;
    }

    public Map<String, TypeDefinition> getUriParameters() {
        return this.uriParameters;
    }

    public Map<String, TypeDefinition> getHeaders() {
        return this.headers;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getUri() {
        return this.uri;
    }

    public Map<String, TypeDefinition> getParameters() {
        return this.parameters;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCanonicalName() {
        return this.canonicalName;
    }

    public void setCanonicalName(String canonicalName) {
        this.canonicalName = canonicalName;
    }

    public TypeDefinition getInputMetadata() {
        return this.inputMetadata;
    }

    public TypeDefinition getOutputMetadata() {
        return this.outputMetadata;
    }

    public String getAnnotatedDisplayName() {
        return this.annotatedDisplayName;
    }
}

