/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.model.security;

import java.util.HashSet;
import java.util.List;
import org.mule.connectivity.restconnect.internal.model.security.APISecurityScheme;

public abstract class OAuth2Scheme
extends APISecurityScheme {
    private String authorizationUri;
    private String accessTokenUri;
    private List<String> authorizationGrants;
    private List<String> scopes;
    public static final String OAUTH2_GRANT_AUTHORIZATION_CODE = "authorization_code";
    public static final String OAUTH2_GRANT_CLIENT_CREDENTIALS = "client_credentials";

    public OAuth2Scheme(String authorizationUri, String accessTokenUri, List<String> grants, List<String> scopes) {
        this.authorizationUri = authorizationUri;
        this.authorizationGrants = grants;
        this.accessTokenUri = accessTokenUri;
        this.scopes = scopes;
        this.initializeConfigParameters();
    }

    @Override
    public String getSchemeName() {
        return "OAuth 2.0";
    }

    public String getAuthorizationUri() {
        return this.authorizationUri;
    }

    public String getAccessTokenUri() {
        return this.accessTokenUri;
    }

    public List<String> getAuthorizationGrants() {
        return this.authorizationGrants;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public boolean supportsAuthorizationGrant(String authorizationGrant) {
        return this.authorizationGrants.contains(authorizationGrant);
    }

    @Override
    protected boolean equalProperties(APISecurityScheme scheme) {
        OAuth2Scheme other = (OAuth2Scheme)scheme;
        return new HashSet<String>(other.getScopes()).equals(new HashSet<String>(this.getScopes())) && this.equalOrBothNull(other.getAuthorizationUri(), this.getAuthorizationUri()) && this.equalOrBothNull(other.getAccessTokenUri(), this.getAccessTokenUri()) && new HashSet<String>(other.getAuthorizationGrants()).equals(new HashSet<String>(this.getAuthorizationGrants()));
    }

    protected boolean equalOrBothNull(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }
}

