/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.modelGeneration.amf;

import amf.client.model.domain.EndPoint;
import amf.client.model.domain.Operation;
import amf.client.model.domain.WebApi;
import java.util.ArrayList;
import java.util.List;
import org.mule.connectivity.restconnect.exception.UnsupportedSecuritySchemeException;
import org.mule.connectivity.restconnect.internal.model.HTTPMethod;
import org.mule.connectivity.restconnect.internal.model.operation.OperationBuilder;
import org.mule.connectivity.restconnect.internal.model.parameter.Parameter;
import org.mule.connectivity.restconnect.internal.modelGeneration.amf.TypeDefinitionFactory;
import org.mule.connectivity.restconnect.internal.modelGeneration.amf.security.SecuritySchemeFactory;
import org.mule.connectivity.restconnect.internal.modelGeneration.amf.util.AMFParserUtil;

public class AMFOperationGenerator {
    public static org.mule.connectivity.restconnect.internal.model.operation.Operation generateOperation(WebApi api, EndPoint endPoint, Operation operation) throws UnsupportedSecuritySchemeException {
        String friendlyName = AMFParserUtil.getMethodDisplayName(endPoint, operation);
        return new OperationBuilder().withFriendlyName(friendlyName).withAnnotatedDisplayName(AMFParserUtil.getAnnotatedOperationName(operation)).withCanonicalName(AMFParserUtil.getCanonicalOperationName(endPoint, operation, friendlyName)).withDescription(AMFOperationGenerator.buildOperationDescription(endPoint, operation)).withHttpMethod(HTTPMethod.fromString(operation.method().value())).withUri(endPoint.path().value()).withUriParams(AMFOperationGenerator.buildUriParams(endPoint)).withQueryParams(AMFOperationGenerator.buildQueryParams(operation)).withHeaders(AMFOperationGenerator.buildHeaders(operation)).withInputMetadata(TypeDefinitionFactory.buildInputMetadata(operation)).withOutputMetadata(TypeDefinitionFactory.buildOutputMetadata(operation)).withSecuritySchemes(SecuritySchemeFactory.getSchemesForOperation(api, endPoint, operation)).build();
    }

    private static String buildOperationDescription(EndPoint endPoint, Operation operation) {
        return operation.description().nonEmpty() ? operation.description().value() : endPoint.description().value();
    }

    private static List<Parameter> buildUriParams(EndPoint endPoint) {
        return AMFParserUtil.getParameterList(endPoint.parameters());
    }

    private static List<Parameter> buildQueryParams(Operation operation) {
        if (operation.request() != null) {
            return AMFParserUtil.getParameterList(operation.request().queryParameters());
        }
        return new ArrayList<Parameter>();
    }

    private static List<Parameter> buildHeaders(Operation operation) {
        if (operation.request() != null) {
            return AMFParserUtil.getParameterList(operation.request().headers());
        }
        return new ArrayList<Parameter>();
    }
}

