/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser.resourceLoader;

import com.google.common.base.Strings;
import java.io.File;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.raml.v2.api.loader.FileResourceLoader;
import org.raml.v2.api.loader.ResourceLoader;

public class ExchangeDependencyResourceLoader
implements ResourceLoader {
    private String basePath = ".";
    private File workingDir = null;
    private ResourceLoader resourceLoader = null;
    private static final Pattern DEPENDENCY_PATH_PATTERN = Pattern.compile("^exchange_modules/|/exchange_modules/");

    public ExchangeDependencyResourceLoader() {
        this.basePath = ".";
        this.workingDir = new File(this.basePath);
        this.resourceLoader = new FileResourceLoader(this.basePath);
    }

    public ExchangeDependencyResourceLoader(String rootDir) {
        this.basePath = rootDir != null ? rootDir : ".";
        this.workingDir = new File(this.basePath);
        this.resourceLoader = new FileResourceLoader(this.basePath);
    }

    @Nullable
    public InputStream fetchResource(String path) {
        if (Strings.isNullOrEmpty((String)path)) {
            return null;
        }
        Matcher matcher = DEPENDENCY_PATH_PATTERN.matcher(path);
        if (matcher.find()) {
            int dependencyIndex = path.lastIndexOf(matcher.group(0));
            String resourceName = dependencyIndex <= 0 ? path : path.substring(dependencyIndex);
            return this.resourceLoader.fetchResource(new File(this.workingDir, resourceName).getAbsolutePath());
        }
        return null;
    }
}

