/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templateEngine;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.tools.ToolManager;
import org.mule.connectivity.restconnect.internal.model.security.APISecurityScheme;
import org.mule.connectivity.restconnect.internal.model.security.OAuth2Scheme;
import org.mule.connectivity.restconnect.internal.templateEngine.SmartConnectorGeneratedSources;
import org.mule.connectivity.restconnect.internal.templateEngine.TemplateEngine;
import org.mule.connectivity.restconnect.internal.templateEngine.builder.SmartConnectorTemplateEngineBuilder;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.model.SmartConnectorModelDecorator;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.operation.SmartConnectorOperationDecorator;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.type.SmartConnectorTypeDefinitionDecorator;
import org.mule.connectivity.restconnect.internal.util.FileGenerationUtils;

public class SmartConnectorTemplateEngine
extends TemplateEngine {
    private static final String SUPPORTS_BASIC_AUTH = "SUPPORTS_BASIC_AUTH";
    private static final String SUPPORTS_PASS_THROUGH = "SUPPORTS_PASS_THROUGH";
    private static final String SUPPORTS_DIGEST_AUTHENTICATION = "SUPPORTS_DIGEST_AUTHENTICATION";
    private static final String SUPPORTS_OAUTH2 = "SUPPORTS_OAUTH2";
    private static final String SUPPORTS_OAUTH2_CLIENT_CREDENTIALS = "SUPPORTS_OAUTH2_CLIENT_CREDENTIALS";
    private static final String SUPPORTS_OAUTH2_AUTHORIZATION_CODE = "SUPPORTS_OAUTH2_AUTHORIZATION_CODE";
    private static final String EXTENSION = "extension";
    private static final String ACTIVE_SECURITY_SCHEME = "activeSecurityScheme";
    private static final String CATALOG_VM = "templates/smartConnector/catalog.vm";
    private static final String MODULE_VM = "templates/smartConnector/module.vm";
    private static final String MULE_ARTIFACT_VM = "templates/smartConnector/mule-artifact.vm";
    private static final String POM_VM = "templates/smartConnector/pom.vm";
    private static final String ICON_PATH = "images/icon.svg";
    private static final Path RESOURCES_DIR = Paths.get("src/main/resources", new String[0]);
    private static final String PROPERTIES_RESOURCE = "/project.properties";
    private static final String APPLICATION_PROPERTIES = "properties";
    private final SmartConnectorModelDecorator model;
    private final Path outputDir;
    private SmartConnectorGeneratedSources generatedSources;

    public SmartConnectorTemplateEngine(SmartConnectorTemplateEngineBuilder builder) {
        this.model = new SmartConnectorModelDecorator(builder.getModel());
        this.outputDir = builder.getOutputDir();
        this.generatedSources = new SmartConnectorGeneratedSources(this.outputDir);
    }

    @Override
    public void applyTemplates() throws Exception {
        this.generateCatalog();
        this.generateVMTemplates();
        this.generateAssetFiles();
    }

    private void generateAssetFiles() throws IOException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        Path output = this.outputDir.resolve("icon.svg");
        InputStream stream = classLoader.getResourceAsStream(ICON_PATH);
        byte[] buffer = new byte[stream.available()];
        stream.read(buffer);
        File targetFile = output.toFile();
        FileOutputStream outStream = new FileOutputStream(targetFile);
        ((OutputStream)outStream).write(buffer);
        this.generatedSources.setIcon(output);
    }

    private void generateCatalog() throws IOException {
        Path outputResourcesDir = this.outputDir.resolve(RESOURCES_DIR);
        for (SmartConnectorOperationDecorator operation : this.model.getDecoratedOperations()) {
            if (operation.getDecoratedInputMetadata() != null && operation.getDecoratedInputMetadata().requiresCatalog()) {
                this.generatedSources.getCatalogSchemas().add(operation.getDecoratedInputMetadata().writeSchema(outputResourcesDir));
            }
            if (operation.getDecoratedOutputMetadata() != null && operation.getDecoratedOutputMetadata().requiresCatalog()) {
                this.generatedSources.getCatalogSchemas().add(operation.getDecoratedOutputMetadata().writeSchema(outputResourcesDir));
            }
            for (SmartConnectorTypeDefinitionDecorator parameter : operation.getDecoratedParameters()) {
                if (!parameter.requiresCatalog()) continue;
                this.generatedSources.getCatalogSchemas().add(parameter.writeSchema(outputResourcesDir));
            }
        }
    }

    private void generateVMTemplates() throws Exception {
        ToolManager velocityToolManager = new ToolManager();
        velocityToolManager.configure("velocity-tools.xml");
        VelocityContext context = new VelocityContext((Context)velocityToolManager.createContext());
        context.internalPut(EXTENSION, (Object)this.model);
        context.internalPut(APPLICATION_PROPERTIES, (Object)this.getApplicationProperties());
        Path outputResourcesDir = this.outputDir.resolve(RESOURCES_DIR);
        this.generatedSources.setPom(this.applyTemplate(POM_VM, this.outputDir.resolve("pom.xml"), context));
        this.generatedSources.setModule(this.applyTemplate(MODULE_VM, outputResourcesDir.resolve(String.format("module-%s.xml", this.model.getModulePrefix())), context));
        this.generatedSources.setCatalog(this.applyTemplate(CATALOG_VM, outputResourcesDir.resolve(String.format("module-%s-catalog.xml", this.model.getModulePrefix())), context));
        this.generatedSources.setArtifact(this.applyTemplate(MULE_ARTIFACT_VM, this.outputDir.resolve("mule-artifact.json"), context));
    }

    public void packageProject() throws IOException {
        Path packageFolder = this.outputDir.resolve("package");
        Files.createDirectories(packageFolder, new FileAttribute[0]);
        this.createJarFile(packageFolder);
    }

    private void createJarFile(Path packageFolder) throws IOException {
        Path jarDir = Files.createTempDirectory("jar-temp", new FileAttribute[0]);
        Path metaInfDir = jarDir.resolve(Paths.get("META-INF", new String[0]));
        metaInfDir.toFile().mkdirs();
        Path muleArtifactDir = metaInfDir.resolve(Paths.get("mule-artifact", new String[0]));
        muleArtifactDir.toFile().mkdirs();
        Path mavenDir = metaInfDir.resolve(Paths.get("maven/" + this.model.getGroupId() + "/" + this.model.getArtifactId(), new String[0]));
        mavenDir.toFile().mkdirs();
        Files.copy(this.generatedSources.getCatalog(), jarDir.resolve(this.generatedSources.getCatalog().getFileName()), new CopyOption[0]);
        Files.copy(this.generatedSources.getModule(), jarDir.resolve(this.generatedSources.getModule().getFileName()), new CopyOption[0]);
        Files.copy(this.generatedSources.getArtifact(), muleArtifactDir.resolve(this.generatedSources.getArtifact().getFileName()), new CopyOption[0]);
        Files.copy(this.generatedSources.getIcon(), muleArtifactDir.resolve(this.generatedSources.getIcon().getFileName()), new CopyOption[0]);
        Files.copy(this.generatedSources.getPom(), mavenDir.resolve(this.generatedSources.getPom().getFileName()), new CopyOption[0]);
        for (Path path : this.generatedSources.getDistinctCatalogSchemas()) {
            Files.copy(path, jarDir.resolve(path.getFileName()), new CopyOption[0]);
        }
        String jarName = String.format("%s-%s-mule-plugin.jar", this.model.getArtifactId(), this.model.getVersion());
        Path outputJarFile = packageFolder.resolve(jarName);
        FileGenerationUtils.generateJarFileFromDirectory(jarDir, outputJarFile);
    }

    private Properties getApplicationProperties() throws IOException {
        try (InputStream input = this.getClass().getResourceAsStream(PROPERTIES_RESOURCE);){
            Properties prop = new Properties();
            prop.load(input);
            Properties properties = prop;
            return properties;
        }
    }

    private String getGrants(List<APISecurityScheme> schemas) {
        ArrayList<String> grants = new ArrayList<String>();
        for (APISecurityScheme schema : schemas) {
            if (!(schema instanceof OAuth2Scheme)) continue;
            grants.addAll(((OAuth2Scheme)schema).getAuthorizationGrants());
        }
        return StringUtils.join(grants, (String)", ");
    }
}

