/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templateEngine.decorator.operation;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.mule.connectivity.restconnect.internal.model.operation.Operation;
import org.mule.connectivity.restconnect.internal.model.parameter.Parameter;
import org.mule.connectivity.restconnect.internal.model.security.APISecurityScheme;
import org.mule.connectivity.restconnect.internal.model.type.TypeDefinitionBuilder;
import org.mule.connectivity.restconnect.internal.modelGeneration.util.ParserUtils;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.model.SmartConnectorSecuritySchemeHelper;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.operation.OperationDecorator;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.SmartConnectorSecuritySchemeDecorator;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.SmartConnectorSecuritySchemeDecoratorFactory;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.type.SmartConnectorTypeDefinitionDecorator;
import org.mule.connectivity.restconnect.internal.util.DataWeaveUtils;

public class SmartConnectorOperationDecorator
extends OperationDecorator {
    private final SmartConnectorTypeDefinitionDecorator outputMetadata;
    private final SmartConnectorTypeDefinitionDecorator inputMetadata = this.buildInputMetadata();
    private final List<SmartConnectorTypeDefinitionDecorator> parameters;
    private final SmartConnectorSecuritySchemeDecorator securitySchemeDecorator;

    public SmartConnectorOperationDecorator(Operation operation, HashMap<APISecurityScheme, String> securitySchemesNames) {
        super(operation);
        this.outputMetadata = this.buildOutputMetadata();
        this.parameters = SmartConnectorOperationDecorator.buildDecoratedParameters(this.getParameters());
        this.securitySchemeDecorator = SmartConnectorOperationDecorator.buildDecoratedSecurityScheme(operation, securitySchemesNames);
    }

    public static List<SmartConnectorTypeDefinitionDecorator> buildDecoratedParameters(List<Parameter> parameters) {
        return SmartConnectorOperationDecorator.buildDecoratedParameters(parameters, "");
    }

    public static List<SmartConnectorTypeDefinitionDecorator> buildDecoratedParameters(List<Parameter> parameters, String namePrefix) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Parameter param : parameters) {
            builder.add((Object)new SmartConnectorTypeDefinitionDecorator((!namePrefix.isEmpty() ? namePrefix + "-" : "") + param.getName(), param.getTypeDefinition(), param.isPassword()));
        }
        return builder.build();
    }

    protected static SmartConnectorSecuritySchemeDecorator buildDecoratedSecurityScheme(Operation operation, HashMap<APISecurityScheme, String> securitySchemesNames) {
        return SmartConnectorSecuritySchemeDecoratorFactory.getSecuritySchemeDecorator(SmartConnectorSecuritySchemeHelper.getPrioritarySecurityScheme(operation.getSecuritySchemes()), securitySchemesNames);
    }

    private SmartConnectorTypeDefinitionDecorator buildOutputMetadata() {
        if (this.getOutputMetadata() == null) {
            return null;
        }
        SmartConnectorTypeDefinitionDecorator outputMetadata = new SmartConnectorTypeDefinitionDecorator(this.getOutputMetadata());
        outputMetadata.setName(this.getName() + "-response-data");
        outputMetadata.setType(this.getName() + "-response-type");
        return outputMetadata;
    }

    private SmartConnectorTypeDefinitionDecorator buildInputMetadata() {
        if (this.getInputMetadata() == null) {
            return null;
        }
        SmartConnectorTypeDefinitionDecorator inputMetadata = new SmartConnectorTypeDefinitionDecorator(this.getInputMetadata());
        inputMetadata.setName(this.getName() + "-request-data");
        inputMetadata.setType(this.getName() + "-request-type");
        return inputMetadata;
    }

    @Override
    public List<Parameter> getHeaders() {
        List<Parameter> baseHeaders = this.operation.getHeaders();
        boolean hasAcceptHeader = false;
        for (Parameter param : baseHeaders) {
            if (!param.getName().toLowerCase().equals("accept")) continue;
            hasAcceptHeader = true;
        }
        if (!hasAcceptHeader && this.outputMetadata != null && this.outputMetadata.hasMediaType()) {
            LinkedList<Parameter> headers = new LinkedList<Parameter>();
            Parameter fixedValueHeader = new Parameter("Accept", TypeDefinitionBuilder.buildHeaderType());
            fixedValueHeader.setFixedValue(this.outputMetadata.getMediaType());
            headers.add(fixedValueHeader);
            headers.addAll(baseHeaders);
            return headers;
        }
        return baseHeaders;
    }

    public String getName() {
        return ParserUtils.getXmlName(this.getCanonicalName());
    }

    public SmartConnectorTypeDefinitionDecorator getDecoratedInputMetadata() {
        return this.inputMetadata;
    }

    public SmartConnectorTypeDefinitionDecorator getDecoratedOutputMetadata() {
        return this.outputMetadata;
    }

    public List<SmartConnectorTypeDefinitionDecorator> getDecoratedParameters() {
        return this.parameters;
    }

    public String getQueryParametersDW() {
        return DataWeaveUtils.getParametersDW(this.getQueryParameters(), null);
    }

    public String getUriParametersDW() {
        return DataWeaveUtils.getParametersDW(this.getUriParameters(), null);
    }

    public String getHeadersDW() {
        return DataWeaveUtils.getParametersDW(this.getHeaders(), null);
    }

    public boolean hasInputParameters() {
        return this.getInputMetadata() != null || !this.getParameters().isEmpty();
    }

    public SmartConnectorSecuritySchemeDecorator getSecurityScheme() {
        return this.securitySchemeDecorator;
    }
}

