/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.mojo;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.mule.connectivity.restconnect.api.ConnectorType;
import org.mule.connectivity.restconnect.api.Parser;
import org.mule.connectivity.restconnect.api.RestConnect;
import org.mule.connectivity.restconnect.api.SpecFormat;
import org.mule.connectivity.restconnect.internal.util.MojoUtils;
import org.mule.connectivity.restconnect.mojo.Raml2ConnectorMojo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="raml2smartconnector", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresProject=false)
public class Raml2SmartConnectorMojo
extends AbstractMojo {
    private Logger logger = LoggerFactory.getLogger(Raml2ConnectorMojo.class);
    @Parameter(property="raml", required=true)
    private String raml;
    @Parameter(property="name")
    private String name;
    @Parameter(property="packageConnector", defaultValue="true")
    private boolean packageConnector;
    @Parameter(property="outputDir", defaultValue="target")
    private File outputDir;
    @Parameter(property="specFormat", defaultValue="raml")
    private String specFormat;
    @Parameter(property="parser", defaultValue="any")
    private String parser;

    public void execute() throws MojoExecutionException {
        try {
            RestConnect.getInstance().createConnectorFromSpec(MojoUtils.getMainRamlFile(this.raml), SpecFormat.getFromString(this.specFormat), Parser.getFromString(this.parser), ConnectorType.SmartConnector).withApiName(this.name).withOutputDir(this.outputDir.toPath()).withPackageConnector(this.packageConnector).run();
        }
        catch (Exception e) {
            this.logger.error("Failed to build connector.", (Throwable)e);
            throw new MojoExecutionException("Failed to build connector", e);
        }
    }
}

