/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.model.security;

import java.util.LinkedList;
import java.util.List;
import org.mule.connectivity.restconnect.internal.model.parameter.Parameter;
import org.mule.connectivity.restconnect.internal.model.type.TypeDefinition;
import org.mule.connectivity.restconnect.internal.model.type.TypeDefinitionBuilder;
import org.mule.connectivity.restconnect.internal.model.typesource.PrimitiveTypeSource;

public abstract class APISecurityScheme {
    public static final String BASIC = "Basic Authentication";
    public static final String OAUTH1 = "OAuth 1.0";
    public static final String OAUTH2 = "OAuth 2.0";
    public static final String PASS_THROUGH = "Pass Through";
    public static final String DIGEST_AUTHENTICATION = "Digest Authentication";
    public static final String CUSTOM_AUTHENTICATION = "Custom Authentication";
    public static final String UNSECURED = "";
    protected List<Parameter> configParameters = new LinkedList<Parameter>();
    protected List<Parameter> headers = new LinkedList<Parameter>();
    protected List<Parameter> queryParameters = new LinkedList<Parameter>();

    public APISecurityScheme() {
        this.initializeConfigParameters();
    }

    public abstract String getSchemeName();

    public abstract String getConfigurationName();

    public abstract String getTemplateLocation();

    public abstract void initializeConfigParameters();

    public List<Parameter> getConfigParameters() {
        return this.configParameters;
    }

    public List<Parameter> getQueryParameters() {
        return this.queryParameters;
    }

    public List<Parameter> getHeaders() {
        return this.headers;
    }

    public boolean hasQueryParameters() {
        return !this.queryParameters.isEmpty();
    }

    public boolean hasHeaders() {
        return !this.headers.isEmpty();
    }

    public boolean hasConfigParameters() {
        return !this.configParameters.isEmpty();
    }

    public boolean equals(APISecurityScheme scheme) {
        return scheme.getClass().equals(this.getClass()) && scheme.getSchemeName().equals(this.getSchemeName()) && this.equalProperties(scheme);
    }

    protected abstract boolean equalProperties(APISecurityScheme var1);

    public static Parameter getSecuritySchemeParameter(String name, String displayName, PrimitiveTypeSource.PrimitiveType type, String description, String defaultValue, String example, boolean required, boolean isPassword) {
        TypeDefinition typeDefinition = TypeDefinitionBuilder.buildSimplePrimitiveType(type, required);
        typeDefinition.setAnnotatedDisplayName(displayName);
        typeDefinition.setDescription(description);
        typeDefinition.setRequired(required);
        typeDefinition.setDefaultValue(defaultValue);
        typeDefinition.setExample(example);
        return new Parameter(name, typeDefinition, isPassword);
    }
}

