/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.model.security;

import java.util.Arrays;
import java.util.List;
import org.mule.connectivity.restconnect.internal.model.security.OAuth2Scheme;
import org.mule.connectivity.restconnect.internal.model.typesource.PrimitiveTypeSource;

public class OAuth2ClientCredentialsScheme
extends OAuth2Scheme {
    private static final String OAUTH2_CONFIG_TEMPLATE_VM = "templates/devkit/OAuth2ClientCredentialsConfig.vm";

    public OAuth2ClientCredentialsScheme(String authorizationUri, String accessTokenUri, List<String> grants, List<String> scopes) {
        super(authorizationUri, accessTokenUri, grants, scopes);
    }

    @Override
    public String getConfigurationName() {
        return "OAuth2ClientCredentialsConfig.java";
    }

    @Override
    public String getTemplateLocation() {
        return OAUTH2_CONFIG_TEMPLATE_VM;
    }

    @Override
    public void initializeConfigParameters() {
        StringBuilder scopeBuilder = new StringBuilder();
        if (this.getScopes() != null) {
            for (String scope : this.getScopes()) {
                scopeBuilder.append(scope);
                scopeBuilder.append(" ");
            }
        }
        this.configParameters = Arrays.asList(OAuth2ClientCredentialsScheme.getSecuritySchemeParameter("clientId", "clientId", PrimitiveTypeSource.PrimitiveType.STRING, "OAuth2 Client Id", null, null, true, false), OAuth2ClientCredentialsScheme.getSecuritySchemeParameter("clientSecret", "clientSecret", PrimitiveTypeSource.PrimitiveType.STRING, "OAuth2 Client Secret", null, null, true, true), OAuth2ClientCredentialsScheme.getSecuritySchemeParameter("accessTokenUrl", "accessTokenUrl", PrimitiveTypeSource.PrimitiveType.STRING, "Token URL for consuming API", this.getAccessTokenUri(), this.getAccessTokenUri(), true, false), OAuth2ClientCredentialsScheme.getSecuritySchemeParameter("scopes", "scopes", PrimitiveTypeSource.PrimitiveType.STRING, "List of requested scopes separated by spaces", scopeBuilder.toString(), scopeBuilder.toString(), true, false));
    }
}

