/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.model.uri;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class BaseUri {
    private URI uri;
    private List<String> parameters = new LinkedList<String>();

    public BaseUri(String uriStr) throws URISyntaxException {
        this.parameters = BaseUri.extractCustomUriParameters(uriStr);
        this.uri = new URI(this.getDeparametrizedString(uriStr));
    }

    private String getDeparametrizedString(String str) {
        String deparametrizedString = str;
        if (StringUtils.isEmpty((CharSequence)deparametrizedString)) {
            return deparametrizedString;
        }
        for (String param : this.parameters) {
            deparametrizedString = deparametrizedString.replace("{" + param + "}", "beginparam" + param + "endparam");
        }
        return deparametrizedString;
    }

    private String getParametrizedString(String str) {
        String parametrizedString = str;
        if (StringUtils.isEmpty((CharSequence)parametrizedString)) {
            return parametrizedString;
        }
        for (String param : this.parameters) {
            parametrizedString = parametrizedString.replace("beginparam" + param + "endparam", "[" + param + "]");
        }
        return parametrizedString;
    }

    private static List<String> extractCustomUriParameters(String uriString) {
        Pattern pattern = Pattern.compile("(\\{.*\\})");
        Matcher matcher = pattern.matcher(uriString);
        LinkedList<String> parameters = new LinkedList<String>();
        while (matcher.find()) {
            String matchedString = matcher.group(1).substring(1);
            matchedString = matchedString.substring(0, matchedString.length() - 1);
            parameters.add(matchedString);
        }
        return parameters;
    }

    public boolean isAbsolute() {
        return this.uri.isAbsolute();
    }

    public String getPath() {
        return this.getParametrizedString(this.uri.getPath());
    }

    public String getScheme() {
        return this.getParametrizedString(this.uri.getScheme());
    }

    public String getHost() {
        return this.getParametrizedString(this.uri.getHost());
    }

    public Integer getPort() {
        return this.uri.getPort();
    }

    public String toString() {
        return this.getParametrizedString(this.uri.toString());
    }
}

