/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.modelGeneration.amf.security;

import amf.client.model.StrField;
import amf.client.model.domain.EndPoint;
import amf.client.model.domain.OAuth2Settings;
import amf.client.model.domain.Operation;
import amf.client.model.domain.ParametrizedSecurityScheme;
import amf.client.model.domain.SecurityScheme;
import amf.client.model.domain.WebApi;
import edu.emory.mathcs.backport.java.util.Arrays;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.connectivity.restconnect.exception.UnsupportedSecuritySchemeException;
import org.mule.connectivity.restconnect.internal.model.parameter.Parameter;
import org.mule.connectivity.restconnect.internal.model.security.APISecurityScheme;
import org.mule.connectivity.restconnect.internal.model.security.BasicAuthScheme;
import org.mule.connectivity.restconnect.internal.model.security.CustomAuthenticationScheme;
import org.mule.connectivity.restconnect.internal.model.security.DigestAuthenticationScheme;
import org.mule.connectivity.restconnect.internal.model.security.OAuth2AuthorizationCodeScheme;
import org.mule.connectivity.restconnect.internal.model.security.OAuth2ClientCredentialsScheme;
import org.mule.connectivity.restconnect.internal.model.security.PassThroughScheme;
import org.mule.connectivity.restconnect.internal.model.security.UnsecuredScheme;
import org.mule.connectivity.restconnect.internal.modelGeneration.amf.util.AMFParserUtil;

public class SecuritySchemeFactory {
    public static List<APISecurityScheme> getSchemesForOperation(WebApi api, EndPoint endPoint, Operation operation) throws UnsupportedSecuritySchemeException {
        List<SecurityScheme> globalSchemes = endPoint.security().stream().map(x -> SecuritySchemeFactory.getScheme(x)).collect(Collectors.toList());
        List<SecurityScheme> endPointSchemes = endPoint.security().stream().map(x -> SecuritySchemeFactory.getScheme(x)).collect(Collectors.toList());
        List<SecurityScheme> operationSchemes = operation.security().stream().map(x -> (SecurityScheme)x).collect(Collectors.toList());
        List<APISecurityScheme> operationSecuritySchemes = SecuritySchemeFactory.getOperationSecuritySchemes(operationSchemes, endPointSchemes, globalSchemes);
        return operationSecuritySchemes;
    }

    private static List<APISecurityScheme> getOperationSecuritySchemes(List<SecurityScheme> operationSchemes, List<SecurityScheme> endPointSchemes, List<SecurityScheme> globalSchemes) throws UnsupportedSecuritySchemeException {
        if (!operationSchemes.isEmpty()) {
            return SecuritySchemeFactory.getAPISecuritySchemes(operationSchemes);
        }
        if (!endPointSchemes.isEmpty()) {
            return SecuritySchemeFactory.getAPISecuritySchemes(endPointSchemes);
        }
        if (!globalSchemes.isEmpty()) {
            return SecuritySchemeFactory.getAPISecuritySchemes(globalSchemes);
        }
        LinkedList<APISecurityScheme> returnSchemes = new LinkedList<APISecurityScheme>();
        returnSchemes.add(new UnsecuredScheme());
        return returnSchemes;
    }

    private static List<APISecurityScheme> getAPISecuritySchemes(List<SecurityScheme> sourceSchemes) throws UnsupportedSecuritySchemeException {
        LinkedList<APISecurityScheme> returnSchemes = new LinkedList<APISecurityScheme>();
        for (SecurityScheme scheme : sourceSchemes) {
            List<APISecurityScheme> generatedSchemes = SecuritySchemeFactory.createSecuritySchemes(scheme);
            for (APISecurityScheme generatedScheme : generatedSchemes) {
                if (!returnSchemes.stream().noneMatch(x -> x.equals(generatedScheme))) continue;
                returnSchemes.add(generatedScheme);
            }
        }
        if (!sourceSchemes.isEmpty() && returnSchemes.isEmpty()) {
            throw new UnsupportedSecuritySchemeException("None of the specified security schemes ( " + SecuritySchemeFactory.listSchemes(sourceSchemes) + ") are supported.");
        }
        return returnSchemes;
    }

    private static List<APISecurityScheme> createSecuritySchemes(SecurityScheme scheme) {
        ArrayList<APISecurityScheme> apiSecuritySchemes = new ArrayList<APISecurityScheme>();
        if (!scheme.type().nonEmpty()) {
            apiSecuritySchemes.add(new UnsecuredScheme());
            return apiSecuritySchemes;
        }
        switch (scheme.type().value()) {
            case "Basic Authentication": {
                apiSecuritySchemes.add(new BasicAuthScheme());
                return apiSecuritySchemes;
            }
            case "Pass Through": {
                apiSecuritySchemes.add(SecuritySchemeFactory.buildPassThroughSecurityScheme(scheme));
                return apiSecuritySchemes;
            }
            case "OAuth 2.0": {
                OAuth2Settings oAuth2Settings = (OAuth2Settings)scheme.settings();
                for (StrField grant : oAuth2Settings.authorizationGrants()) {
                    String stringGrant = grant.value();
                    if (stringGrant.equals("authorization_code")) {
                        apiSecuritySchemes.add(SecuritySchemeFactory.buildOAuth2AuthorizationCodeSecurityScheme(oAuth2Settings));
                        continue;
                    }
                    if (!stringGrant.equals("client_credentials")) continue;
                    apiSecuritySchemes.add(SecuritySchemeFactory.buildOAuth2ClientCredentialsSecurityScheme(oAuth2Settings));
                }
                return apiSecuritySchemes;
            }
            case "Digest Authentication": {
                apiSecuritySchemes.add(new DigestAuthenticationScheme());
                return apiSecuritySchemes;
            }
            case "OAuth 1.0": {
                return apiSecuritySchemes;
            }
        }
        apiSecuritySchemes.add(SecuritySchemeFactory.buildCustomAuthenticationScheme(scheme));
        return apiSecuritySchemes;
    }

    private static SecurityScheme getScheme(ParametrizedSecurityScheme securityScheme) {
        return securityScheme.scheme().isLink() && securityScheme.scheme().linkTarget() != null ? (SecurityScheme)securityScheme.scheme().linkTarget().get() : securityScheme.scheme();
    }

    private static PassThroughScheme buildPassThroughSecurityScheme(SecurityScheme securityScheme) {
        List<Parameter> queryParameters = AMFParserUtil.getParameterList(securityScheme.queryParameters());
        List<Parameter> headers = AMFParserUtil.getParameterList(securityScheme.headers());
        return new PassThroughScheme(queryParameters, headers);
    }

    private static CustomAuthenticationScheme buildCustomAuthenticationScheme(SecurityScheme securityScheme) {
        List<Parameter> queryParameters = AMFParserUtil.getParameterList(securityScheme.queryParameters());
        List<Parameter> headers = AMFParserUtil.getParameterList(securityScheme.headers());
        return new CustomAuthenticationScheme(queryParameters, headers);
    }

    private static OAuth2AuthorizationCodeScheme buildOAuth2AuthorizationCodeSecurityScheme(OAuth2Settings settings) {
        String authorizationUri = settings.authorizationUri().value();
        String accessTokenUri = settings.accessTokenUri().value();
        List authorizationGrants = Arrays.asList((Object[])new String[]{"authorization_code"});
        List<String> scopes = settings.scopes().stream().map(s -> s.name().value()).collect(Collectors.toList());
        return new OAuth2AuthorizationCodeScheme(authorizationUri, accessTokenUri, authorizationGrants, scopes);
    }

    private static OAuth2ClientCredentialsScheme buildOAuth2ClientCredentialsSecurityScheme(OAuth2Settings settings) {
        String authorizationUri = settings.authorizationUri().value();
        String accessTokenUri = settings.accessTokenUri().value();
        List authorizationGrants = Arrays.asList((Object[])new String[]{"client_credentials"});
        List<String> scopes = settings.scopes().stream().map(s -> s.name().value()).collect(Collectors.toList());
        return new OAuth2ClientCredentialsScheme(authorizationUri, accessTokenUri, authorizationGrants, scopes);
    }

    private static String listSchemes(List<SecurityScheme> securitySchemes) {
        StringBuilder builder = new StringBuilder();
        for (SecurityScheme securityScheme : securitySchemes) {
            builder.append(securityScheme.name());
            builder.append(":");
            builder.append(securityScheme.type().value());
            if (securityScheme.type().equals((Object)"OAuth 2.0") && securityScheme.settings() != null) {
                OAuth2Settings settings = (OAuth2Settings)securityScheme.settings();
                builder.append(" :");
                if (settings.authorizationGrants() != null && settings.authorizationGrants().size() > 0) {
                    for (StrField grant : settings.authorizationGrants()) {
                        builder.append(" ");
                        builder.append(grant.value());
                    }
                }
            }
            builder.append(". ");
        }
        return builder.toString();
    }
}

