/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.modelGeneration.strategy;

import java.io.File;
import java.util.concurrent.ExecutionException;
import org.mule.connectivity.restconnect.api.Parser;
import org.mule.connectivity.restconnect.api.SpecFormat;
import org.mule.connectivity.restconnect.exception.GenerationException;
import org.mule.connectivity.restconnect.internal.model.api.RestConnectModelBuilder;
import org.mule.connectivity.restconnect.internal.modelGeneration.strategy.AMFParserGenerationStrategy;
import org.mule.connectivity.restconnect.internal.modelGeneration.strategy.AnyParserGenerationStrategy;
import org.mule.connectivity.restconnect.internal.modelGeneration.strategy.RAMLParserGenerationStrategy;

public abstract class ModelGenerationStrategy {
    protected final SpecFormat specFormat;

    public ModelGenerationStrategy(SpecFormat format) {
        this.specFormat = format;
    }

    public static ModelGenerationStrategy get(SpecFormat format, Parser parser) {
        if (parser.equals((Object)Parser.ANY)) {
            return new AnyParserGenerationStrategy(format);
        }
        if (parser.equals((Object)Parser.RAMLParser)) {
            return new RAMLParserGenerationStrategy(format);
        }
        if (parser.equals((Object)Parser.AMF)) {
            return new AMFParserGenerationStrategy(format);
        }
        throw new IllegalArgumentException("Parser not supported");
    }

    public abstract RestConnectModelBuilder generateAPIModel(File var1, String var2) throws GenerationException, ExecutionException, InterruptedException;

    public RestConnectModelBuilder generateAPIModel(File raml) throws GenerationException, ExecutionException, InterruptedException {
        return this.generateAPIModel(raml, ".");
    }
}

