/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templateEngine.decorator.operation;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.mule.connectivity.restconnect.internal.model.operation.Operation;
import org.mule.connectivity.restconnect.internal.model.parameter.Parameter;
import org.mule.connectivity.restconnect.internal.model.security.APISecurityScheme;
import org.mule.connectivity.restconnect.internal.modelGeneration.util.ParserUtils;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.operation.OperationDecorator;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.type.DevKitConnectorTypeDefinitionDecorator;

public class DevKitOperationDecorator
extends OperationDecorator {
    private final String basePackage;
    private final DevKitConnectorTypeDefinitionDecorator inputMetadata;
    private final DevKitConnectorTypeDefinitionDecorator outputMetadata;
    private final List<DevKitConnectorTypeDefinitionDecorator> queryParameters;
    private final List<DevKitConnectorTypeDefinitionDecorator> uriParameters;
    private final List<DevKitConnectorTypeDefinitionDecorator> parameters;
    private final List<DevKitConnectorTypeDefinitionDecorator> headers;
    private final List<APISecurityScheme> securitySchemes;

    public DevKitOperationDecorator(Operation operation, String basePackage) {
        super(operation);
        this.basePackage = basePackage;
        this.inputMetadata = this.buildInputMetadata();
        this.outputMetadata = this.buildOutputMetadata();
        this.queryParameters = this.buildDecoratedQueryParameters();
        this.uriParameters = this.buildDecoratedUriParameters();
        this.headers = this.buildDecoratedHeaders();
        this.parameters = this.buildDecoratedParameters();
        this.securitySchemes = operation.getSecuritySchemes();
    }

    private DevKitConnectorTypeDefinitionDecorator buildInputMetadata() {
        if (this.getInputMetadata() == null) {
            return null;
        }
        DevKitConnectorTypeDefinitionDecorator inputMetadata = new DevKitConnectorTypeDefinitionDecorator(this.getInputMetadata(), this.basePackage);
        inputMetadata.setClassName(WordUtils.capitalize((String)this.getMethodName()) + "Request");
        return inputMetadata;
    }

    private DevKitConnectorTypeDefinitionDecorator buildOutputMetadata() {
        if (this.getOutputMetadata() == null) {
            return null;
        }
        DevKitConnectorTypeDefinitionDecorator outputMetadata = new DevKitConnectorTypeDefinitionDecorator(this.getOutputMetadata(), this.basePackage);
        outputMetadata.setClassName(WordUtils.capitalize((String)this.getMethodName()) + "Response");
        return outputMetadata;
    }

    private List<DevKitConnectorTypeDefinitionDecorator> buildDecoratedUriParameters() {
        return this.buildParameters(this.getUriParameters(), "UriParameter");
    }

    private List<DevKitConnectorTypeDefinitionDecorator> buildDecoratedQueryParameters() {
        return this.buildParameters(this.getQueryParameters(), "QueryParameter");
    }

    private List<DevKitConnectorTypeDefinitionDecorator> buildDecoratedHeaders() {
        return this.buildParameters(this.getHeaders(), "Header");
    }

    private List<DevKitConnectorTypeDefinitionDecorator> buildParameters(List<Parameter> parameters, String classifier) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Parameter parameter : parameters) {
            DevKitConnectorTypeDefinitionDecorator typeDefinitionDecorator = new DevKitConnectorTypeDefinitionDecorator(parameter.getName(), parameter.getTypeDefinition(), this.basePackage);
            if (typeDefinitionDecorator.requiresPojo() && StringUtils.isBlank((String)typeDefinitionDecorator.getClassName())) {
                typeDefinitionDecorator.setClassName(WordUtils.capitalize((String)this.getMethodName()) + WordUtils.capitalize((String)classifier) + WordUtils.capitalize((String)parameter.getName()));
            }
            builder.add((Object)typeDefinitionDecorator);
        }
        return builder.build();
    }

    private List<DevKitConnectorTypeDefinitionDecorator> buildDecoratedParameters() {
        return ImmutableList.builder().addAll(this.uriParameters).addAll(this.queryParameters).addAll(this.headers).build();
    }

    public String getMethodName() {
        return ParserUtils.getJavaName(this.operation.getCanonicalName());
    }

    public String getTestClassName() {
        return WordUtils.capitalize((String)this.getMethodName()) + "TestCase";
    }

    public String getArguments() throws IOException {
        ArrayList<String> stream = new ArrayList<String>();
        for (DevKitConnectorTypeDefinitionDecorator parameter : this.getDecoratedParameters()) {
            StringBuilder sb = new StringBuilder();
            if (StringUtils.isNotBlank((String)parameter.getAnnotatedParameterName())) {
                sb.append("@FriendlyName(\"");
                sb.append(parameter.getAnnotatedParameterName());
                sb.append("\") ");
            } else if (!ParserUtils.isValidDevKitParameterName(parameter.getName())) {
                sb.append("@FriendlyName(\"");
                sb.append(parameter.getName());
                sb.append("\") ");
            }
            if (!parameter.isRequired()) {
                sb.append("@Optional ");
            }
            if (parameter.hasDefaultValue()) {
                sb.append("@Default(\"");
                sb.append(parameter.getDefaultValue());
                sb.append("\") ");
            }
            sb.append(parameter.getClassName());
            sb.append(" ");
            sb.append(parameter.getFriendlyName());
            sb.append(" ");
            stream.add(sb.toString());
        }
        if (this.operation.getInputMetadata() != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("@RefOnly @Default(\"#[payload]\") ");
            sb.append(this.getDecoratedInputMetadata().getClassName());
            sb.append(" entity");
            stream.add(sb.toString());
        }
        return Joiner.on((String)", ").join(stream);
    }

    public DevKitConnectorTypeDefinitionDecorator getDecoratedInputMetadata() {
        return this.inputMetadata;
    }

    public DevKitConnectorTypeDefinitionDecorator getDecoratedOutputMetadata() {
        return this.outputMetadata;
    }

    public List<DevKitConnectorTypeDefinitionDecorator> getDecoratedQueryParameters() {
        return this.queryParameters;
    }

    public List<DevKitConnectorTypeDefinitionDecorator> getDecoratedUriParameters() {
        return this.uriParameters;
    }

    public List<DevKitConnectorTypeDefinitionDecorator> getDecoratedHeaders() {
        return this.headers;
    }

    public List<DevKitConnectorTypeDefinitionDecorator> getDecoratedParameters() {
        return this.parameters;
    }

    public List<APISecurityScheme> getSecuritySchemes() {
        return this.securitySchemes;
    }
}

