/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templateEngine.decorator.type;

import java.io.IOException;
import java.nio.file.Path;
import org.mule.connectivity.restconnect.internal.model.type.TypeDefinition;
import org.mule.connectivity.restconnect.internal.model.typesource.PrimitiveTypeSource;
import org.mule.connectivity.restconnect.internal.modelGeneration.util.ParserUtils;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.type.TypeDefinitionDecorator;
import org.mule.connectivity.restconnect.internal.util.FileGenerationUtils;

public class DevKitConnectorTypeDefinitionDecorator
extends TypeDefinitionDecorator {
    private final String basePackage;
    private String fullQualifiedName;
    private String className;

    public DevKitConnectorTypeDefinitionDecorator(String parameterName, TypeDefinition typeDefinition, String basePackage) {
        super(parameterName, typeDefinition);
        this.basePackage = basePackage;
    }

    public DevKitConnectorTypeDefinitionDecorator(TypeDefinition inputMetadata, String basePackage) {
        super(inputMetadata);
        this.basePackage = basePackage;
    }

    public void generatePojo(Path outputDir) throws IOException {
        this.fullQualifiedName = FileGenerationUtils.generatePojo(this.getTypeDefinition().getSource(), this.getClassName(), outputDir.toFile(), this.basePackage);
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getClassName() {
        if (this.isUnionType()) {
            return "String";
        }
        if (this.isPrimitiveType()) {
            return this.getJavaPrimitiveType();
        }
        if (this.fullQualifiedName != null) {
            return this.fullQualifiedName;
        }
        return this.className;
    }

    public String getRequestBuilderResponseType() {
        String genericArgument = this.getListGenericArgumentClassName();
        if (this.isArrayType() || !genericArgument.isEmpty()) {
            return "java.util.List.class, " + genericArgument;
        }
        return this.getClassName() + ".class";
    }

    private String getListGenericArgumentClassName() {
        if (this.getClassName().startsWith("java.util.List<")) {
            return this.getClassName().replaceFirst("java.util.List<", "").replaceFirst(">", "") + ".class";
        }
        return "";
    }

    private String getJavaPrimitiveType() {
        PrimitiveTypeSource typeSource = (PrimitiveTypeSource)this.getTypeDefinition().getSource();
        switch (typeSource.getType()) {
            case BOOLEAN: {
                return "Boolean";
            }
            case NUMBER: 
            case INTEGER: {
                return "Double";
            }
            case DATE: 
            case DATE_TIME: 
            case DATE_ONLY: 
            case DATE_TIME_ONLY: {
                return "Date";
            }
            case FILE: {
                return "File";
            }
            case STRING: {
                return "String";
            }
        }
        throw new IllegalArgumentException("Invalid type value: " + typeSource.toString());
    }

    public String getName() {
        return ParserUtils.removeJavaNameUnwantedCharacters(this.getParameterName());
    }

    public String getFriendlyName() {
        String name = ParserUtils.removeJavaNameUnwantedCharacters(this.getParameterName());
        if (!ParserUtils.isValidDevKitParameterName(name)) {
            return "_" + name;
        }
        return name;
    }

    public boolean requiresPojo() {
        return !this.isPrimitiveType() && !this.isUnionType();
    }
}

