/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templateEngine.decorator.type;

import java.io.IOException;
import java.nio.file.Path;
import org.mule.connectivity.restconnect.internal.model.type.TypeDefinition;
import org.mule.connectivity.restconnect.internal.model.typesource.JsonTypeSource;
import org.mule.connectivity.restconnect.internal.model.typesource.PrimitiveTypeSource;
import org.mule.connectivity.restconnect.internal.model.typesource.XmlTypeSource;
import org.mule.connectivity.restconnect.internal.modelGeneration.util.ParserUtils;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.type.TypeDefinitionDecorator;
import org.mule.connectivity.restconnect.internal.util.FileGenerationUtils;

public class SmartConnectorTypeDefinitionDecorator
extends TypeDefinitionDecorator {
    private static final String DEFAULT_JSON_MEDIA_TYPE = "application/json";
    private static final String DEFAULT_XML_MEDIA_TYPE = "application/xml";
    private static final String FORM_URLENCODED_MEDIA_TYPE = "application/x-www-form-urlencoded";
    private String outputSchemaFilename;
    private String outputSchemaFormat;
    private String name;
    private String type;
    private boolean isPassword;

    public SmartConnectorTypeDefinitionDecorator(TypeDefinition typeDefinition) {
        super(typeDefinition);
        this.isPassword = false;
    }

    public SmartConnectorTypeDefinitionDecorator(String parameterName, TypeDefinition typeDefinition, boolean isPassword) {
        super(parameterName, typeDefinition);
        this.isPassword = isPassword;
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return ParserUtils.getXmlName(this.getParameterName());
    }

    public String getPropertyName() {
        if (this.name != null) {
            return this.name;
        }
        return "property_" + ParserUtils.getXmlName(this.getParameterName());
    }

    public String getType() {
        if (this.isPrimitiveType()) {
            return this.getMule4PrimitiveType();
        }
        if (this.type != null) {
            return this.type;
        }
        return this.getName();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    private String getMule4PrimitiveType() {
        PrimitiveTypeSource typeSource = (PrimitiveTypeSource)this.getTypeDefinition().getSource();
        switch (typeSource.getType()) {
            case INTEGER: 
            case NUMBER: {
                return "number";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case DATE: 
            case DATE_TIME: 
            case DATE_ONLY: 
            case DATE_TIME_ONLY: {
                return "date";
            }
            case TIME_ONLY: {
                return "time";
            }
            case STRING: {
                return "string";
            }
            case FILE: {
                return "binary";
            }
        }
        throw new IllegalArgumentException("Invalid type value: " + typeSource.toString());
    }

    public boolean requiresCatalog() {
        return !this.isPrimitiveType();
    }

    public String getOutputSchemaFilename() {
        return this.outputSchemaFilename;
    }

    public String getOutputSchemaFormat() {
        return this.outputSchemaFormat;
    }

    @Override
    public boolean hasMediaType() {
        return this.getMediaType() != null;
    }

    @Override
    public String getMediaType() {
        String mediaType = this.getMediaTypeForSource();
        if (mediaType == null && this.typeDefinition.getMediaType() != null) {
            return this.typeDefinition.getMediaType().toString();
        }
        return mediaType;
    }

    private String getMediaTypeForSource() {
        if (this.getTypeDefinition().getSource() instanceof XmlTypeSource) {
            return DEFAULT_XML_MEDIA_TYPE;
        }
        if (this.getTypeDefinition().getSource() instanceof JsonTypeSource) {
            return DEFAULT_JSON_MEDIA_TYPE;
        }
        return null;
    }

    public String getMediaTypeForTransformation() {
        if (this.typeDefinition.getMediaType() != null && this.getTypeDefinition().getMediaType().toString().equals(FORM_URLENCODED_MEDIA_TYPE)) {
            return FORM_URLENCODED_MEDIA_TYPE;
        }
        return this.getMediaType();
    }

    public Path writeSchema(Path outputDir) throws IOException {
        Path generatedFile = null;
        this.outputSchemaFilename = FileGenerationUtils.writeSchema(this.getTypeDefinition().getSource(), this.getName() + "-schema", outputDir);
        this.outputSchemaFormat = FileGenerationUtils.getSchemaFormat(this.getTypeDefinition().getSource());
        generatedFile = outputDir.resolve(this.outputSchemaFilename);
        return generatedFile;
    }

    public boolean hasElementName() {
        return this.getTypeDefinition().getSource() instanceof XmlTypeSource;
    }

    public String getElementName() {
        return ((XmlTypeSource)this.getTypeDefinition().getSource()).getElementName();
    }

    public boolean isPassword() {
        return this.isPassword;
    }

    public void setPassword(boolean password) {
        this.isPassword = password;
    }
}

