/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.util;

import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JType;
import com.sun.tools.xjc.api.Mapping;
import com.sun.tools.xjc.api.S2JJAXBModel;
import com.sun.tools.xjc.api.SchemaCompiler;
import com.sun.tools.xjc.api.XJC;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.apache.tools.ant.filters.StringInputStream;
import org.jsonschema2pojo.Annotator;
import org.jsonschema2pojo.DefaultGenerationConfig;
import org.jsonschema2pojo.GenerationConfig;
import org.jsonschema2pojo.Jackson2Annotator;
import org.jsonschema2pojo.SchemaGenerator;
import org.jsonschema2pojo.SchemaMapper;
import org.jsonschema2pojo.SchemaStore;
import org.jsonschema2pojo.rules.RuleFactory;
import org.mule.connectivity.restconnect.internal.model.typesource.JsonTypeSource;
import org.mule.connectivity.restconnect.internal.model.typesource.TypeSource;
import org.mule.connectivity.restconnect.internal.model.typesource.XmlTypeSource;
import org.mule.connectivity.restconnect.internal.modelGeneration.util.ParserUtils;
import org.xml.sax.InputSource;

public class FileGenerationUtils {
    private static GenerationConfig config = new DefaultGenerationConfig(){

        public boolean isGenerateBuilders() {
            return true;
        }

        public String getTargetVersion() {
            return "1.7";
        }

        public boolean isIncludeAdditionalProperties() {
            return false;
        }

        public boolean isIncludeHashcodeAndEquals() {
            return false;
        }
    };

    public static String generatePojo(TypeSource source, String opName, File outputDir, String basePackage) throws IOException {
        if (source instanceof XmlTypeSource) {
            return FileGenerationUtils.generatePojo((XmlTypeSource)source, opName, outputDir, basePackage);
        }
        if (source instanceof JsonTypeSource) {
            return FileGenerationUtils.generatePojo((JsonTypeSource)source, opName, outputDir, basePackage);
        }
        throw new IllegalArgumentException("Typesource doesn't support POJO generation.");
    }

    private static String generatePojo(XmlTypeSource source, String opName, File outputDir, String basePackage) throws IOException {
        SchemaCompiler sc = XJC.createSchemaCompiler();
        sc.forcePackageName(basePackage + ".pojo." + ParserUtils.removeJavaNameUnwantedCharacters(opName).toLowerCase());
        InputSource inputSource = new InputSource((InputStream)new StringInputStream(source.getValue()));
        if (inputSource.getSystemId() == null) {
            inputSource.setSystemId("file:///");
        }
        sc.parseSchema(inputSource);
        S2JJAXBModel model = sc.bind();
        JCodeModel jCodeModel = model.generateCode(null, null);
        jCodeModel.build(outputDir);
        return ((Mapping)model.getMappings().iterator().next()).getType().getTypeClass().fullName();
    }

    private static String generatePojo(JsonTypeSource source, String opName, File outputDir, String basePackage) throws IOException {
        SchemaMapper mapper = new SchemaMapper(new RuleFactory(config, (Annotator)new Jackson2Annotator(config), new SchemaStore()), new SchemaGenerator());
        JCodeModel codeModel = new JCodeModel();
        JType generatedModel = mapper.generate(codeModel, opName, basePackage + ".pojo." + ParserUtils.removeJavaNameUnwantedCharacters(opName).toLowerCase(), source.getValue());
        codeModel.build(outputDir);
        return generatedModel.fullName();
    }

    public static String writeSchema(TypeSource source, String name, Path outputDir) throws IOException {
        String filename = name + "." + FileGenerationUtils.getExtension(source);
        FileUtils.writeStringToFile((File)outputDir.resolve(filename).toFile(), (String)source.getValue());
        return filename;
    }

    private static String getExtension(TypeSource source) {
        if (source instanceof XmlTypeSource) {
            return "xsd";
        }
        if (source instanceof JsonTypeSource) {
            return "json";
        }
        throw new IllegalArgumentException("Typesource doesn't support schema generation.");
    }

    public static String getSchemaFormat(TypeSource source) {
        if (source instanceof XmlTypeSource) {
            return "application/xml+schema";
        }
        if (source instanceof JsonTypeSource) {
            return "application/json+schema";
        }
        throw new IllegalArgumentException("Typesource doesn't support schema generation.");
    }

    public static void generateJarFileFromDirectory(Path directory, Path output) throws IOException {
        URI uri;
        File outFile = output.toFile();
        ArrayList files = new ArrayList();
        Files.walk(directory, new FileVisitOption[0]).forEach(path -> files.add(path.toFile()));
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", "true");
        try {
            uri = URI.create("jar:file:" + outFile.getAbsolutePath());
        }
        catch (Exception e) {
            uri = URI.create(outFile.getAbsolutePath());
        }
        try (FileSystem zipfs = FileSystems.newFileSystem(uri, env);){
            for (File file : files) {
                if (!file.isFile()) continue;
                Path externalTxtFile = Paths.get(file.getAbsolutePath(), new String[0]);
                String pathInZip = file.getAbsolutePath().replaceFirst(directory.toString(), "");
                Path pathInZipfile = zipfs.getPath(pathInZip, new String[0]);
                Files.createDirectories(pathInZipfile, new FileAttribute[0]);
                Files.delete(pathInZipfile);
                Files.copy(externalTxtFile, pathInZipfile, StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }
}

